/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponseApprovalTeam;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponseApprovalTeamsCopier;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApprovalTeamsResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, ListApprovalTeamsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApprovalTeamsResponse.getter(ListApprovalTeamsResponse::nextToken)).setter(ListApprovalTeamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListApprovalTeamsResponseApprovalTeam>> APPROVAL_TEAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApprovalTeams").getter(ListApprovalTeamsResponse.getter(ListApprovalTeamsResponse::approvalTeams)).setter(ListApprovalTeamsResponse.setter(Builder::approvalTeams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListApprovalTeamsResponseApprovalTeam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, APPROVAL_TEAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApprovalTeamsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListApprovalTeamsResponseApprovalTeam> approvalTeams;

    private ListApprovalTeamsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.approvalTeams = builder.approvalTeams;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasApprovalTeams() {
        return this.approvalTeams != null && !(this.approvalTeams instanceof SdkAutoConstructList);
    }

    public final List<ListApprovalTeamsResponseApprovalTeam> approvalTeams() {
        return this.approvalTeams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovalTeams() ? this.approvalTeams() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApprovalTeamsResponse)) {
            return false;
        }
        ListApprovalTeamsResponse other = (ListApprovalTeamsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasApprovalTeams() == other.hasApprovalTeams() && Objects.equals(this.approvalTeams(), other.approvalTeams());
    }

    public final String toString() {
        return ToString.builder((String)"ListApprovalTeamsResponse").add("NextToken", (Object)this.nextToken()).add("ApprovalTeams", this.hasApprovalTeams() ? this.approvalTeams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApprovalTeams": {
                return Optional.ofNullable(clazz.cast(this.approvalTeams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ApprovalTeams", APPROVAL_TEAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApprovalTeamsResponse, T> g) {
        return obj -> g.apply((ListApprovalTeamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListApprovalTeamsResponseApprovalTeam> approvalTeams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListApprovalTeamsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.approvalTeams(model.approvalTeams);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListApprovalTeamsResponseApprovalTeam.Builder> getApprovalTeams() {
            List<ListApprovalTeamsResponseApprovalTeam.Builder> result = ListApprovalTeamsResponseApprovalTeamsCopier.copyToBuilder(this.approvalTeams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovalTeams(Collection<ListApprovalTeamsResponseApprovalTeam.BuilderImpl> approvalTeams) {
            this.approvalTeams = ListApprovalTeamsResponseApprovalTeamsCopier.copyFromBuilder(approvalTeams);
        }

        @Override
        public final Builder approvalTeams(Collection<ListApprovalTeamsResponseApprovalTeam> approvalTeams) {
            this.approvalTeams = ListApprovalTeamsResponseApprovalTeamsCopier.copy(approvalTeams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalTeams(ListApprovalTeamsResponseApprovalTeam ... approvalTeams) {
            this.approvalTeams(Arrays.asList(approvalTeams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalTeams(Consumer<ListApprovalTeamsResponseApprovalTeam.Builder> ... approvalTeams) {
            this.approvalTeams(Stream.of(approvalTeams).map(c -> (ListApprovalTeamsResponseApprovalTeam)((ListApprovalTeamsResponseApprovalTeam.Builder)ListApprovalTeamsResponseApprovalTeam.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListApprovalTeamsResponse build() {
            return new ListApprovalTeamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApprovalTeamsResponse> {
        public Builder nextToken(String var1);

        public Builder approvalTeams(Collection<ListApprovalTeamsResponseApprovalTeam> var1);

        public Builder approvalTeams(ListApprovalTeamsResponseApprovalTeam ... var1);

        public Builder approvalTeams(Consumer<ListApprovalTeamsResponseApprovalTeam.Builder> ... var1);
    }
}

