/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyAsyncClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerDetail;

public class ListServersPublisher
implements SdkPublisher<ListServersResponse> {
    private final MigrationHubStrategyAsyncClient client;
    private final ListServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServersPublisher(MigrationHubStrategyAsyncClient client, ListServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServersPublisher(MigrationHubStrategyAsyncClient client, ListServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServerDetail> serverInfos() {
        Function<ListServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverInfos() != null) {
                return response.serverInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServersResponseFetcher
    implements AsyncPageFetcher<ListServersResponse> {
        private ListServersResponseFetcher() {
        }

        public boolean hasNextPage(ListServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServersResponse> nextPage(ListServersResponse previousPage) {
            if (previousPage == null) {
                return ListServersPublisher.this.client.listServers(ListServersPublisher.this.firstRequest);
            }
            return ListServersPublisher.this.client.listServers((ListServersRequest)((Object)ListServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

