/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BinaryAnalyzerName {
    DLL_ANALYZER("DLL_ANALYZER"),
    BYTECODE_ANALYZER("BYTECODE_ANALYZER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BinaryAnalyzerName> VALUE_MAP;
    private final String value;

    private BinaryAnalyzerName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BinaryAnalyzerName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BinaryAnalyzerName> knownValues() {
        EnumSet<BinaryAnalyzerName> knownValues = EnumSet.allOf(BinaryAnalyzerName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BinaryAnalyzerName.class, BinaryAnalyzerName::toString);
    }
}

