/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyAsyncClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse;

public class ListApplicationComponentsPublisher
implements SdkPublisher<ListApplicationComponentsResponse> {
    private final MigrationHubStrategyAsyncClient client;
    private final ListApplicationComponentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationComponentsPublisher(MigrationHubStrategyAsyncClient client, ListApplicationComponentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationComponentsPublisher(MigrationHubStrategyAsyncClient client, ListApplicationComponentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationComponentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationComponentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationComponentDetail> applicationComponentInfos() {
        Function<ListApplicationComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationComponentInfos() != null) {
                return response.applicationComponentInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationComponentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationComponentsResponseFetcher
    implements AsyncPageFetcher<ListApplicationComponentsResponse> {
        private ListApplicationComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationComponentsResponse> nextPage(ListApplicationComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationComponentsPublisher.this.client.listApplicationComponents(ListApplicationComponentsPublisher.this.firstRequest);
            }
            return ListApplicationComponentsPublisher.this.client.listApplicationComponents((ListApplicationComponentsRequest)((Object)ListApplicationComponentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

