/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.HttpMethod;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.HttpMethodsCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.PathResourceToIdCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteState;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteSummary> {
    private static final SdkField<Boolean> APPEND_SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AppendSourcePath").getter(RouteSummary.getter(RouteSummary::appendSourcePath)).setter(RouteSummary.setter(Builder::appendSourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendSourcePath").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(RouteSummary.getter(RouteSummary::applicationId)).setter(RouteSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RouteSummary.getter(RouteSummary::arn)).setter(RouteSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedByAccountId").getter(RouteSummary.getter(RouteSummary::createdByAccountId)).setter(RouteSummary.setter(Builder::createdByAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(RouteSummary.getter(RouteSummary::createdTime)).setter(RouteSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(RouteSummary.getter(RouteSummary::environmentId)).setter(RouteSummary.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<ErrorResponse> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(RouteSummary.getter(RouteSummary::error)).setter(RouteSummary.setter(Builder::error)).constructor(ErrorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CHILD_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeChildPaths").getter(RouteSummary.getter(RouteSummary::includeChildPaths)).setter(RouteSummary.setter(Builder::includeChildPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeChildPaths").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(RouteSummary.getter(RouteSummary::lastUpdatedTime)).setter(RouteSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<List<String>> METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Methods").getter(RouteSummary.getter(RouteSummary::methodsAsStrings)).setter(RouteSummary.setter(Builder::methodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Methods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(RouteSummary.getter(RouteSummary::ownerAccountId)).setter(RouteSummary.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<Map<String, String>> PATH_RESOURCE_TO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PathResourceToId").getter(RouteSummary.getter(RouteSummary::pathResourceToId)).setter(RouteSummary.setter(Builder::pathResourceToId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathResourceToId").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteId").getter(RouteSummary.getter(RouteSummary::routeId)).setter(RouteSummary.setter(Builder::routeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteId").build()}).build();
    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteType").getter(RouteSummary.getter(RouteSummary::routeTypeAsString)).setter(RouteSummary.setter(Builder::routeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(RouteSummary.getter(RouteSummary::serviceId)).setter(RouteSummary.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()}).build();
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePath").getter(RouteSummary.getter(RouteSummary::sourcePath)).setter(RouteSummary.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RouteSummary.getter(RouteSummary::stateAsString)).setter(RouteSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RouteSummary.getter(RouteSummary::tags)).setter(RouteSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPEND_SOURCE_PATH_FIELD, APPLICATION_ID_FIELD, ARN_FIELD, CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, ENVIRONMENT_ID_FIELD, ERROR_FIELD, INCLUDE_CHILD_PATHS_FIELD, LAST_UPDATED_TIME_FIELD, METHODS_FIELD, OWNER_ACCOUNT_ID_FIELD, PATH_RESOURCE_TO_ID_FIELD, ROUTE_ID_FIELD, ROUTE_TYPE_FIELD, SERVICE_ID_FIELD, SOURCE_PATH_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean appendSourcePath;
    private final String applicationId;
    private final String arn;
    private final String createdByAccountId;
    private final Instant createdTime;
    private final String environmentId;
    private final ErrorResponse error;
    private final Boolean includeChildPaths;
    private final Instant lastUpdatedTime;
    private final List<String> methods;
    private final String ownerAccountId;
    private final Map<String, String> pathResourceToId;
    private final String routeId;
    private final String routeType;
    private final String serviceId;
    private final String sourcePath;
    private final String state;
    private final Map<String, String> tags;

    private RouteSummary(BuilderImpl builder) {
        this.appendSourcePath = builder.appendSourcePath;
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.environmentId = builder.environmentId;
        this.error = builder.error;
        this.includeChildPaths = builder.includeChildPaths;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.methods = builder.methods;
        this.ownerAccountId = builder.ownerAccountId;
        this.pathResourceToId = builder.pathResourceToId;
        this.routeId = builder.routeId;
        this.routeType = builder.routeType;
        this.serviceId = builder.serviceId;
        this.sourcePath = builder.sourcePath;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final Boolean appendSourcePath() {
        return this.appendSourcePath;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdByAccountId() {
        return this.createdByAccountId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final ErrorResponse error() {
        return this.error;
    }

    public final Boolean includeChildPaths() {
        return this.includeChildPaths;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final List<HttpMethod> methods() {
        return HttpMethodsCopier.copyStringToEnum(this.methods);
    }

    public final boolean hasMethods() {
        return this.methods != null && !(this.methods instanceof SdkAutoConstructList);
    }

    public final List<String> methodsAsStrings() {
        return this.methods;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final boolean hasPathResourceToId() {
        return this.pathResourceToId != null && !(this.pathResourceToId instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> pathResourceToId() {
        return this.pathResourceToId;
    }

    public final String routeId() {
        return this.routeId;
    }

    public final RouteType routeType() {
        return RouteType.fromValue(this.routeType);
    }

    public final String routeTypeAsString() {
        return this.routeType;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String sourcePath() {
        return this.sourcePath;
    }

    public final RouteState state() {
        return RouteState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appendSourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeChildPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMethods() ? this.methodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPathResourceToId() ? this.pathResourceToId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSummary)) {
            return false;
        }
        RouteSummary other = (RouteSummary)obj;
        return Objects.equals(this.appendSourcePath(), other.appendSourcePath()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdByAccountId(), other.createdByAccountId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.includeChildPaths(), other.includeChildPaths()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasMethods() == other.hasMethods() && Objects.equals(this.methodsAsStrings(), other.methodsAsStrings()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && this.hasPathResourceToId() == other.hasPathResourceToId() && Objects.equals(this.pathResourceToId(), other.pathResourceToId()) && Objects.equals(this.routeId(), other.routeId()) && Objects.equals(this.routeTypeAsString(), other.routeTypeAsString()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.sourcePath(), other.sourcePath()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RouteSummary").add("AppendSourcePath", (Object)this.appendSourcePath()).add("ApplicationId", (Object)this.applicationId()).add("Arn", (Object)this.arn()).add("CreatedByAccountId", (Object)this.createdByAccountId()).add("CreatedTime", (Object)this.createdTime()).add("EnvironmentId", (Object)this.environmentId()).add("Error", (Object)this.error()).add("IncludeChildPaths", (Object)this.includeChildPaths()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Methods", this.hasMethods() ? this.methodsAsStrings() : null).add("OwnerAccountId", (Object)this.ownerAccountId()).add("PathResourceToId", this.hasPathResourceToId() ? this.pathResourceToId() : null).add("RouteId", (Object)this.routeId()).add("RouteType", (Object)this.routeTypeAsString()).add("ServiceId", (Object)this.serviceId()).add("SourcePath", (Object)this.sourcePath()).add("State", (Object)this.stateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppendSourcePath": {
                return Optional.ofNullable(clazz.cast(this.appendSourcePath()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedByAccountId": {
                return Optional.ofNullable(clazz.cast(this.createdByAccountId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "IncludeChildPaths": {
                return Optional.ofNullable(clazz.cast(this.includeChildPaths()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Methods": {
                return Optional.ofNullable(clazz.cast(this.methodsAsStrings()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "PathResourceToId": {
                return Optional.ofNullable(clazz.cast(this.pathResourceToId()));
            }
            case "RouteId": {
                return Optional.ofNullable(clazz.cast(this.routeId()));
            }
            case "RouteType": {
                return Optional.ofNullable(clazz.cast(this.routeTypeAsString()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "SourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppendSourcePath", APPEND_SOURCE_PATH_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedByAccountId", CREATED_BY_ACCOUNT_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("IncludeChildPaths", INCLUDE_CHILD_PATHS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Methods", METHODS_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("PathResourceToId", PATH_RESOURCE_TO_ID_FIELD);
        map.put("RouteId", ROUTE_ID_FIELD);
        map.put("RouteType", ROUTE_TYPE_FIELD);
        map.put("ServiceId", SERVICE_ID_FIELD);
        map.put("SourcePath", SOURCE_PATH_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteSummary, T> g) {
        return obj -> g.apply((RouteSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean appendSourcePath;
        private String applicationId;
        private String arn;
        private String createdByAccountId;
        private Instant createdTime;
        private String environmentId;
        private ErrorResponse error;
        private Boolean includeChildPaths;
        private Instant lastUpdatedTime;
        private List<String> methods = DefaultSdkAutoConstructList.getInstance();
        private String ownerAccountId;
        private Map<String, String> pathResourceToId = DefaultSdkAutoConstructMap.getInstance();
        private String routeId;
        private String routeType;
        private String serviceId;
        private String sourcePath;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSummary model) {
            this.appendSourcePath(model.appendSourcePath);
            this.applicationId(model.applicationId);
            this.arn(model.arn);
            this.createdByAccountId(model.createdByAccountId);
            this.createdTime(model.createdTime);
            this.environmentId(model.environmentId);
            this.error(model.error);
            this.includeChildPaths(model.includeChildPaths);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.methodsWithStrings(model.methods);
            this.ownerAccountId(model.ownerAccountId);
            this.pathResourceToId(model.pathResourceToId);
            this.routeId(model.routeId);
            this.routeType(model.routeType);
            this.serviceId(model.serviceId);
            this.sourcePath(model.sourcePath);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final Boolean getAppendSourcePath() {
            return this.appendSourcePath;
        }

        public final void setAppendSourcePath(Boolean appendSourcePath) {
            this.appendSourcePath = appendSourcePath;
        }

        @Override
        public final Builder appendSourcePath(Boolean appendSourcePath) {
            this.appendSourcePath = appendSourcePath;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return this.createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final ErrorResponse.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorResponse.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorResponse error) {
            this.error = error;
            return this;
        }

        public final Boolean getIncludeChildPaths() {
            return this.includeChildPaths;
        }

        public final void setIncludeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
        }

        @Override
        public final Builder includeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getMethods() {
            if (this.methods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.methods;
        }

        public final void setMethods(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
        }

        @Override
        public final Builder methodsWithStrings(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methodsWithStrings(String ... methods) {
            this.methodsWithStrings(Arrays.asList(methods));
            return this;
        }

        @Override
        public final Builder methods(Collection<HttpMethod> methods) {
            this.methods = HttpMethodsCopier.copyEnumToString(methods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methods(HttpMethod ... methods) {
            this.methods(Arrays.asList(methods));
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final Map<String, String> getPathResourceToId() {
            if (this.pathResourceToId instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.pathResourceToId;
        }

        public final void setPathResourceToId(Map<String, String> pathResourceToId) {
            this.pathResourceToId = PathResourceToIdCopier.copy(pathResourceToId);
        }

        @Override
        public final Builder pathResourceToId(Map<String, String> pathResourceToId) {
            this.pathResourceToId = PathResourceToIdCopier.copy(pathResourceToId);
            return this;
        }

        public final String getRouteId() {
            return this.routeId;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final String getRouteType() {
            return this.routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public RouteSummary build() {
            return new RouteSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteSummary> {
        public Builder appendSourcePath(Boolean var1);

        public Builder applicationId(String var1);

        public Builder arn(String var1);

        public Builder createdByAccountId(String var1);

        public Builder createdTime(Instant var1);

        public Builder environmentId(String var1);

        public Builder error(ErrorResponse var1);

        default public Builder error(Consumer<ErrorResponse.Builder> error) {
            return this.error((ErrorResponse)((ErrorResponse.Builder)ErrorResponse.builder().applyMutation(error)).build());
        }

        public Builder includeChildPaths(Boolean var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder methodsWithStrings(Collection<String> var1);

        public Builder methodsWithStrings(String ... var1);

        public Builder methods(Collection<HttpMethod> var1);

        public Builder methods(HttpMethod ... var1);

        public Builder ownerAccountId(String var1);

        public Builder pathResourceToId(Map<String, String> var1);

        public Builder routeId(String var1);

        public Builder routeType(String var1);

        public Builder routeType(RouteType var1);

        public Builder serviceId(String var1);

        public Builder sourcePath(String var1);

        public Builder state(String var1);

        public Builder state(RouteState var1);

        public Builder tags(Map<String, String> var1);
    }
}

