/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxySummary;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationState;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private static final SdkField<ApiGatewayProxySummary> API_GATEWAY_PROXY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiGatewayProxy").getter(ApplicationSummary.getter(ApplicationSummary::apiGatewayProxy)).setter(ApplicationSummary.setter(Builder::apiGatewayProxy)).constructor(ApiGatewayProxySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayProxy").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(ApplicationSummary.getter(ApplicationSummary::applicationId)).setter(ApplicationSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ApplicationSummary.getter(ApplicationSummary::arn)).setter(ApplicationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedByAccountId").getter(ApplicationSummary.getter(ApplicationSummary::createdByAccountId)).setter(ApplicationSummary.setter(Builder::createdByAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ApplicationSummary.getter(ApplicationSummary::createdTime)).setter(ApplicationSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(ApplicationSummary.getter(ApplicationSummary::environmentId)).setter(ApplicationSummary.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<ErrorResponse> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(ApplicationSummary.getter(ApplicationSummary::error)).setter(ApplicationSummary.setter(Builder::error)).constructor(ErrorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(ApplicationSummary.getter(ApplicationSummary::lastUpdatedTime)).setter(ApplicationSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ApplicationSummary.getter(ApplicationSummary::name)).setter(ApplicationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(ApplicationSummary.getter(ApplicationSummary::ownerAccountId)).setter(ApplicationSummary.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> PROXY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyType").getter(ApplicationSummary.getter(ApplicationSummary::proxyTypeAsString)).setter(ApplicationSummary.setter(Builder::proxyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ApplicationSummary.getter(ApplicationSummary::stateAsString)).setter(ApplicationSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ApplicationSummary.getter(ApplicationSummary::tags)).setter(ApplicationSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ApplicationSummary.getter(ApplicationSummary::vpcId)).setter(ApplicationSummary.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_PROXY_FIELD, APPLICATION_ID_FIELD, ARN_FIELD, CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, ENVIRONMENT_ID_FIELD, ERROR_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, OWNER_ACCOUNT_ID_FIELD, PROXY_TYPE_FIELD, STATE_FIELD, TAGS_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ApiGatewayProxySummary apiGatewayProxy;
    private final String applicationId;
    private final String arn;
    private final String createdByAccountId;
    private final Instant createdTime;
    private final String environmentId;
    private final ErrorResponse error;
    private final Instant lastUpdatedTime;
    private final String name;
    private final String ownerAccountId;
    private final String proxyType;
    private final String state;
    private final Map<String, String> tags;
    private final String vpcId;

    private ApplicationSummary(BuilderImpl builder) {
        this.apiGatewayProxy = builder.apiGatewayProxy;
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.environmentId = builder.environmentId;
        this.error = builder.error;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.ownerAccountId = builder.ownerAccountId;
        this.proxyType = builder.proxyType;
        this.state = builder.state;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public final ApiGatewayProxySummary apiGatewayProxy() {
        return this.apiGatewayProxy;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdByAccountId() {
        return this.createdByAccountId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final ErrorResponse error() {
        return this.error;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final ProxyType proxyType() {
        return ProxyType.fromValue(this.proxyType);
    }

    public final String proxyTypeAsString() {
        return this.proxyType;
    }

    public final ApplicationState state() {
        return ApplicationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayProxy());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.apiGatewayProxy(), other.apiGatewayProxy()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdByAccountId(), other.createdByAccountId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.proxyTypeAsString(), other.proxyTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApiGatewayProxy", (Object)this.apiGatewayProxy()).add("ApplicationId", (Object)this.applicationId()).add("Arn", (Object)this.arn()).add("CreatedByAccountId", (Object)this.createdByAccountId()).add("CreatedTime", (Object)this.createdTime()).add("EnvironmentId", (Object)this.environmentId()).add("Error", (Object)this.error()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Name", (Object)this.name()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("ProxyType", (Object)this.proxyTypeAsString()).add("State", (Object)this.stateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiGatewayProxy": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayProxy()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedByAccountId": {
                return Optional.ofNullable(clazz.cast(this.createdByAccountId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "ProxyType": {
                return Optional.ofNullable(clazz.cast(this.proxyTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApiGatewayProxy", API_GATEWAY_PROXY_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedByAccountId", CREATED_BY_ACCOUNT_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("ProxyType", PROXY_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ApiGatewayProxySummary apiGatewayProxy;
        private String applicationId;
        private String arn;
        private String createdByAccountId;
        private Instant createdTime;
        private String environmentId;
        private ErrorResponse error;
        private Instant lastUpdatedTime;
        private String name;
        private String ownerAccountId;
        private String proxyType;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.apiGatewayProxy(model.apiGatewayProxy);
            this.applicationId(model.applicationId);
            this.arn(model.arn);
            this.createdByAccountId(model.createdByAccountId);
            this.createdTime(model.createdTime);
            this.environmentId(model.environmentId);
            this.error(model.error);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.name(model.name);
            this.ownerAccountId(model.ownerAccountId);
            this.proxyType(model.proxyType);
            this.state(model.state);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
        }

        public final ApiGatewayProxySummary.Builder getApiGatewayProxy() {
            return this.apiGatewayProxy != null ? this.apiGatewayProxy.toBuilder() : null;
        }

        public final void setApiGatewayProxy(ApiGatewayProxySummary.BuilderImpl apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy != null ? apiGatewayProxy.build() : null;
        }

        @Override
        public final Builder apiGatewayProxy(ApiGatewayProxySummary apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return this.createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final ErrorResponse.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorResponse.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorResponse error) {
            this.error = error;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getProxyType() {
            return this.proxyType;
        }

        public final void setProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        @Override
        public final Builder proxyType(String proxyType) {
            this.proxyType = proxyType;
            return this;
        }

        @Override
        public final Builder proxyType(ProxyType proxyType) {
            this.proxyType(proxyType == null ? null : proxyType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ApplicationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSummary> {
        public Builder apiGatewayProxy(ApiGatewayProxySummary var1);

        default public Builder apiGatewayProxy(Consumer<ApiGatewayProxySummary.Builder> apiGatewayProxy) {
            return this.apiGatewayProxy((ApiGatewayProxySummary)((ApiGatewayProxySummary.Builder)ApiGatewayProxySummary.builder().applyMutation(apiGatewayProxy)).build());
        }

        public Builder applicationId(String var1);

        public Builder arn(String var1);

        public Builder createdByAccountId(String var1);

        public Builder createdTime(Instant var1);

        public Builder environmentId(String var1);

        public Builder error(ErrorResponse var1);

        default public Builder error(Consumer<ErrorResponse.Builder> error) {
            return this.error((ErrorResponse)((ErrorResponse.Builder)ErrorResponse.builder().applyMutation(error)).build());
        }

        public Builder lastUpdatedTime(Instant var1);

        public Builder name(String var1);

        public Builder ownerAccountId(String var1);

        public Builder proxyType(String var1);

        public Builder proxyType(ProxyType var1);

        public Builder state(String var1);

        public Builder state(ApplicationState var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcId(String var1);
    }
}

