/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.ListSourceResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListSourceResourcesResponse;
import software.amazon.awssdk.services.migrationhub.model.SourceResource;

public class ListSourceResourcesPublisher
implements SdkPublisher<ListSourceResourcesResponse> {
    private final MigrationHubAsyncClient client;
    private final ListSourceResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourceResourcesPublisher(MigrationHubAsyncClient client, ListSourceResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourceResourcesPublisher(MigrationHubAsyncClient client, ListSourceResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourceResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourceResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SourceResource> sourceResourceList() {
        Function<ListSourceResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceResourceList() != null) {
                return response.sourceResourceList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourceResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourceResourcesResponseFetcher
    implements AsyncPageFetcher<ListSourceResourcesResponse> {
        private ListSourceResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourceResourcesResponse> nextPage(ListSourceResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListSourceResourcesPublisher.this.client.listSourceResources(ListSourceResourcesPublisher.this.firstRequest);
            }
            return ListSourceResourcesPublisher.this.client.listSourceResources((ListSourceResourcesRequest)((Object)ListSourceResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

