/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VcenterClient
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VcenterClient> {
    private static final SdkField<String> VCENTER_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vcenterClientID").getter(VcenterClient.getter(VcenterClient::vcenterClientID)).setter(VcenterClient.setter(Builder::vcenterClientID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterClientID").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(VcenterClient.getter(VcenterClient::arn)).setter(VcenterClient.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(VcenterClient.getter(VcenterClient::hostname)).setter(VcenterClient.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> VCENTER_UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vcenterUUID").getter(VcenterClient.getter(VcenterClient::vcenterUUID)).setter(VcenterClient.setter(Builder::vcenterUUID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterUUID").build()}).build();
    private static final SdkField<String> DATACENTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datacenterName").getter(VcenterClient.getter(VcenterClient::datacenterName)).setter(VcenterClient.setter(Builder::datacenterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datacenterName").build()}).build();
    private static final SdkField<String> LAST_SEEN_DATETIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSeenDatetime").getter(VcenterClient.getter(VcenterClient::lastSeenDatetime)).setter(VcenterClient.setter(Builder::lastSeenDatetime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeenDatetime").build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_SERVER_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sourceServerTags").getter(VcenterClient.getter(VcenterClient::sourceServerTags)).setter(VcenterClient.setter(Builder::sourceServerTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(VcenterClient.getter(VcenterClient::tags)).setter(VcenterClient.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VCENTER_CLIENT_ID_FIELD, ARN_FIELD, HOSTNAME_FIELD, VCENTER_UUID_FIELD, DATACENTER_NAME_FIELD, LAST_SEEN_DATETIME_FIELD, SOURCE_SERVER_TAGS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VcenterClient.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vcenterClientID;
    private final String arn;
    private final String hostname;
    private final String vcenterUUID;
    private final String datacenterName;
    private final String lastSeenDatetime;
    private final Map<String, String> sourceServerTags;
    private final Map<String, String> tags;

    private VcenterClient(BuilderImpl builder) {
        this.vcenterClientID = builder.vcenterClientID;
        this.arn = builder.arn;
        this.hostname = builder.hostname;
        this.vcenterUUID = builder.vcenterUUID;
        this.datacenterName = builder.datacenterName;
        this.lastSeenDatetime = builder.lastSeenDatetime;
        this.sourceServerTags = builder.sourceServerTags;
        this.tags = builder.tags;
    }

    public final String vcenterClientID() {
        return this.vcenterClientID;
    }

    public final String arn() {
        return this.arn;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String vcenterUUID() {
        return this.vcenterUUID;
    }

    public final String datacenterName() {
        return this.datacenterName;
    }

    public final String lastSeenDatetime() {
        return this.lastSeenDatetime;
    }

    public final boolean hasSourceServerTags() {
        return this.sourceServerTags != null && !(this.sourceServerTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sourceServerTags() {
        return this.sourceServerTags;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vcenterClientID());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcenterUUID());
        hashCode = 31 * hashCode + Objects.hashCode(this.datacenterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeenDatetime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServerTags() ? this.sourceServerTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VcenterClient)) {
            return false;
        }
        VcenterClient other = (VcenterClient)obj;
        return Objects.equals(this.vcenterClientID(), other.vcenterClientID()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.vcenterUUID(), other.vcenterUUID()) && Objects.equals(this.datacenterName(), other.datacenterName()) && Objects.equals(this.lastSeenDatetime(), other.lastSeenDatetime()) && this.hasSourceServerTags() == other.hasSourceServerTags() && Objects.equals(this.sourceServerTags(), other.sourceServerTags()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"VcenterClient").add("VcenterClientID", (Object)this.vcenterClientID()).add("Arn", (Object)this.arn()).add("Hostname", (Object)this.hostname()).add("VcenterUUID", (Object)this.vcenterUUID()).add("DatacenterName", (Object)this.datacenterName()).add("LastSeenDatetime", (Object)this.lastSeenDatetime()).add("SourceServerTags", (Object)(this.sourceServerTags() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vcenterClientID": {
                return Optional.ofNullable(clazz.cast(this.vcenterClientID()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "vcenterUUID": {
                return Optional.ofNullable(clazz.cast(this.vcenterUUID()));
            }
            case "datacenterName": {
                return Optional.ofNullable(clazz.cast(this.datacenterName()));
            }
            case "lastSeenDatetime": {
                return Optional.ofNullable(clazz.cast(this.lastSeenDatetime()));
            }
            case "sourceServerTags": {
                return Optional.ofNullable(clazz.cast(this.sourceServerTags()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vcenterClientID", VCENTER_CLIENT_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("vcenterUUID", VCENTER_UUID_FIELD);
        map.put("datacenterName", DATACENTER_NAME_FIELD);
        map.put("lastSeenDatetime", LAST_SEEN_DATETIME_FIELD);
        map.put("sourceServerTags", SOURCE_SERVER_TAGS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VcenterClient, T> g) {
        return obj -> g.apply((VcenterClient)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vcenterClientID;
        private String arn;
        private String hostname;
        private String vcenterUUID;
        private String datacenterName;
        private String lastSeenDatetime;
        private Map<String, String> sourceServerTags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VcenterClient model) {
            this.vcenterClientID(model.vcenterClientID);
            this.arn(model.arn);
            this.hostname(model.hostname);
            this.vcenterUUID(model.vcenterUUID);
            this.datacenterName(model.datacenterName);
            this.lastSeenDatetime(model.lastSeenDatetime);
            this.sourceServerTags(model.sourceServerTags);
            this.tags(model.tags);
        }

        public final String getVcenterClientID() {
            return this.vcenterClientID;
        }

        public final void setVcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
        }

        @Override
        public final Builder vcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getVcenterUUID() {
            return this.vcenterUUID;
        }

        public final void setVcenterUUID(String vcenterUUID) {
            this.vcenterUUID = vcenterUUID;
        }

        @Override
        public final Builder vcenterUUID(String vcenterUUID) {
            this.vcenterUUID = vcenterUUID;
            return this;
        }

        public final String getDatacenterName() {
            return this.datacenterName;
        }

        public final void setDatacenterName(String datacenterName) {
            this.datacenterName = datacenterName;
        }

        @Override
        public final Builder datacenterName(String datacenterName) {
            this.datacenterName = datacenterName;
            return this;
        }

        public final String getLastSeenDatetime() {
            return this.lastSeenDatetime;
        }

        public final void setLastSeenDatetime(String lastSeenDatetime) {
            this.lastSeenDatetime = lastSeenDatetime;
        }

        @Override
        public final Builder lastSeenDatetime(String lastSeenDatetime) {
            this.lastSeenDatetime = lastSeenDatetime;
            return this;
        }

        public final Map<String, String> getSourceServerTags() {
            if (this.sourceServerTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sourceServerTags;
        }

        public final void setSourceServerTags(Map<String, String> sourceServerTags) {
            this.sourceServerTags = TagsMapCopier.copy(sourceServerTags);
        }

        @Override
        public final Builder sourceServerTags(Map<String, String> sourceServerTags) {
            this.sourceServerTags = TagsMapCopier.copy(sourceServerTags);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public VcenterClient build() {
            return new VcenterClient(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VcenterClient> {
        public Builder vcenterClientID(String var1);

        public Builder arn(String var1);

        public Builder hostname(String var1);

        public Builder vcenterUUID(String var1);

        public Builder datacenterName(String var1);

        public Builder lastSeenDatetime(String var1);

        public Builder sourceServerTags(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);
    }
}

