/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.DataReplicationInfo;
import software.amazon.awssdk.services.mgn.model.LaunchedInstance;
import software.amazon.awssdk.services.mgn.model.LifeCycle;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.ReplicationType;
import software.amazon.awssdk.services.mgn.model.SourceProperties;
import software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MarkAsArchivedResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, MarkAsArchivedResponse> {
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::sourceServerID)).setter(MarkAsArchivedResponse.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::arn)).setter(MarkAsArchivedResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::isArchived)).setter(MarkAsArchivedResponse.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::tags)).setter(MarkAsArchivedResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LaunchedInstance> LAUNCHED_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchedInstance").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::launchedInstance)).setter(MarkAsArchivedResponse.setter(Builder::launchedInstance)).constructor(LaunchedInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedInstance").build()}).build();
    private static final SdkField<DataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationInfo").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::dataReplicationInfo)).setter(MarkAsArchivedResponse.setter(Builder::dataReplicationInfo)).constructor(DataReplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build()}).build();
    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifeCycle").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::lifeCycle)).setter(MarkAsArchivedResponse.setter(Builder::lifeCycle)).constructor(LifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()}).build();
    private static final SdkField<SourceProperties> SOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceProperties").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::sourceProperties)).setter(MarkAsArchivedResponse.setter(Builder::sourceProperties)).constructor(SourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()}).build();
    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationType").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::replicationTypeAsString)).setter(MarkAsArchivedResponse.setter(Builder::replicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationType").build()}).build();
    private static final SdkField<String> VCENTER_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vcenterClientID").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::vcenterClientID)).setter(MarkAsArchivedResponse.setter(Builder::vcenterClientID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterClientID").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationID").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::applicationID)).setter(MarkAsArchivedResponse.setter(Builder::applicationID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationID").build()}).build();
    private static final SdkField<String> USER_PROVIDED_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userProvidedID").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::userProvidedID)).setter(MarkAsArchivedResponse.setter(Builder::userProvidedID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProvidedID").build()}).build();
    private static final SdkField<String> FQDN_FOR_ACTION_FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fqdnForActionFramework").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::fqdnForActionFramework)).setter(MarkAsArchivedResponse.setter(Builder::fqdnForActionFramework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fqdnForActionFramework").build()}).build();
    private static final SdkField<SourceServerConnectorAction> CONNECTOR_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorAction").getter(MarkAsArchivedResponse.getter(MarkAsArchivedResponse::connectorAction)).setter(MarkAsArchivedResponse.setter(Builder::connectorAction)).constructor(SourceServerConnectorAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SERVER_ID_FIELD, ARN_FIELD, IS_ARCHIVED_FIELD, TAGS_FIELD, LAUNCHED_INSTANCE_FIELD, DATA_REPLICATION_INFO_FIELD, LIFE_CYCLE_FIELD, SOURCE_PROPERTIES_FIELD, REPLICATION_TYPE_FIELD, VCENTER_CLIENT_ID_FIELD, APPLICATION_ID_FIELD, USER_PROVIDED_ID_FIELD, FQDN_FOR_ACTION_FRAMEWORK_FIELD, CONNECTOR_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MarkAsArchivedResponse.memberNameToFieldInitializer();
    private final String sourceServerID;
    private final String arn;
    private final Boolean isArchived;
    private final Map<String, String> tags;
    private final LaunchedInstance launchedInstance;
    private final DataReplicationInfo dataReplicationInfo;
    private final LifeCycle lifeCycle;
    private final SourceProperties sourceProperties;
    private final String replicationType;
    private final String vcenterClientID;
    private final String applicationID;
    private final String userProvidedID;
    private final String fqdnForActionFramework;
    private final SourceServerConnectorAction connectorAction;

    private MarkAsArchivedResponse(BuilderImpl builder) {
        super(builder);
        this.sourceServerID = builder.sourceServerID;
        this.arn = builder.arn;
        this.isArchived = builder.isArchived;
        this.tags = builder.tags;
        this.launchedInstance = builder.launchedInstance;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.lifeCycle = builder.lifeCycle;
        this.sourceProperties = builder.sourceProperties;
        this.replicationType = builder.replicationType;
        this.vcenterClientID = builder.vcenterClientID;
        this.applicationID = builder.applicationID;
        this.userProvidedID = builder.userProvidedID;
        this.fqdnForActionFramework = builder.fqdnForActionFramework;
        this.connectorAction = builder.connectorAction;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final LaunchedInstance launchedInstance() {
        return this.launchedInstance;
    }

    public final DataReplicationInfo dataReplicationInfo() {
        return this.dataReplicationInfo;
    }

    public final LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public final SourceProperties sourceProperties() {
        return this.sourceProperties;
    }

    public final ReplicationType replicationType() {
        return ReplicationType.fromValue(this.replicationType);
    }

    public final String replicationTypeAsString() {
        return this.replicationType;
    }

    public final String vcenterClientID() {
        return this.vcenterClientID;
    }

    public final String applicationID() {
        return this.applicationID;
    }

    public final String userProvidedID() {
        return this.userProvidedID;
    }

    public final String fqdnForActionFramework() {
        return this.fqdnForActionFramework;
    }

    public final SourceServerConnectorAction connectorAction() {
        return this.connectorAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcenterClientID());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationID());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProvidedID());
        hashCode = 31 * hashCode + Objects.hashCode(this.fqdnForActionFramework());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarkAsArchivedResponse)) {
            return false;
        }
        MarkAsArchivedResponse other = (MarkAsArchivedResponse)((Object)obj);
        return Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.isArchived(), other.isArchived()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.launchedInstance(), other.launchedInstance()) && Objects.equals(this.dataReplicationInfo(), other.dataReplicationInfo()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.sourceProperties(), other.sourceProperties()) && Objects.equals(this.replicationTypeAsString(), other.replicationTypeAsString()) && Objects.equals(this.vcenterClientID(), other.vcenterClientID()) && Objects.equals(this.applicationID(), other.applicationID()) && Objects.equals(this.userProvidedID(), other.userProvidedID()) && Objects.equals(this.fqdnForActionFramework(), other.fqdnForActionFramework()) && Objects.equals(this.connectorAction(), other.connectorAction());
    }

    public final String toString() {
        return ToString.builder((String)"MarkAsArchivedResponse").add("SourceServerID", (Object)this.sourceServerID()).add("Arn", (Object)this.arn()).add("IsArchived", (Object)this.isArchived()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("LaunchedInstance", (Object)this.launchedInstance()).add("DataReplicationInfo", (Object)this.dataReplicationInfo()).add("LifeCycle", (Object)this.lifeCycle()).add("SourceProperties", (Object)this.sourceProperties()).add("ReplicationType", (Object)this.replicationTypeAsString()).add("VcenterClientID", (Object)this.vcenterClientID()).add("ApplicationID", (Object)this.applicationID()).add("UserProvidedID", (Object)this.userProvidedID()).add("FqdnForActionFramework", (Object)this.fqdnForActionFramework()).add("ConnectorAction", (Object)this.connectorAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "launchedInstance": {
                return Optional.ofNullable(clazz.cast(this.launchedInstance()));
            }
            case "dataReplicationInfo": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationInfo()));
            }
            case "lifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "sourceProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProperties()));
            }
            case "replicationType": {
                return Optional.ofNullable(clazz.cast(this.replicationTypeAsString()));
            }
            case "vcenterClientID": {
                return Optional.ofNullable(clazz.cast(this.vcenterClientID()));
            }
            case "applicationID": {
                return Optional.ofNullable(clazz.cast(this.applicationID()));
            }
            case "userProvidedID": {
                return Optional.ofNullable(clazz.cast(this.userProvidedID()));
            }
            case "fqdnForActionFramework": {
                return Optional.ofNullable(clazz.cast(this.fqdnForActionFramework()));
            }
            case "connectorAction": {
                return Optional.ofNullable(clazz.cast(this.connectorAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("launchedInstance", LAUNCHED_INSTANCE_FIELD);
        map.put("dataReplicationInfo", DATA_REPLICATION_INFO_FIELD);
        map.put("lifeCycle", LIFE_CYCLE_FIELD);
        map.put("sourceProperties", SOURCE_PROPERTIES_FIELD);
        map.put("replicationType", REPLICATION_TYPE_FIELD);
        map.put("vcenterClientID", VCENTER_CLIENT_ID_FIELD);
        map.put("applicationID", APPLICATION_ID_FIELD);
        map.put("userProvidedID", USER_PROVIDED_ID_FIELD);
        map.put("fqdnForActionFramework", FQDN_FOR_ACTION_FRAMEWORK_FIELD);
        map.put("connectorAction", CONNECTOR_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MarkAsArchivedResponse, T> g) {
        return obj -> g.apply((MarkAsArchivedResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private String sourceServerID;
        private String arn;
        private Boolean isArchived;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private LaunchedInstance launchedInstance;
        private DataReplicationInfo dataReplicationInfo;
        private LifeCycle lifeCycle;
        private SourceProperties sourceProperties;
        private String replicationType;
        private String vcenterClientID;
        private String applicationID;
        private String userProvidedID;
        private String fqdnForActionFramework;
        private SourceServerConnectorAction connectorAction;

        private BuilderImpl() {
        }

        private BuilderImpl(MarkAsArchivedResponse model) {
            super(model);
            this.sourceServerID(model.sourceServerID);
            this.arn(model.arn);
            this.isArchived(model.isArchived);
            this.tags(model.tags);
            this.launchedInstance(model.launchedInstance);
            this.dataReplicationInfo(model.dataReplicationInfo);
            this.lifeCycle(model.lifeCycle);
            this.sourceProperties(model.sourceProperties);
            this.replicationType(model.replicationType);
            this.vcenterClientID(model.vcenterClientID);
            this.applicationID(model.applicationID);
            this.userProvidedID(model.userProvidedID);
            this.fqdnForActionFramework(model.fqdnForActionFramework);
            this.connectorAction(model.connectorAction);
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final LaunchedInstance.Builder getLaunchedInstance() {
            return this.launchedInstance != null ? this.launchedInstance.toBuilder() : null;
        }

        public final void setLaunchedInstance(LaunchedInstance.BuilderImpl launchedInstance) {
            this.launchedInstance = launchedInstance != null ? launchedInstance.build() : null;
        }

        @Override
        public final Builder launchedInstance(LaunchedInstance launchedInstance) {
            this.launchedInstance = launchedInstance;
            return this;
        }

        public final DataReplicationInfo.Builder getDataReplicationInfo() {
            return this.dataReplicationInfo != null ? this.dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(DataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        public final Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final SourceProperties.Builder getSourceProperties() {
            return this.sourceProperties != null ? this.sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final String getReplicationType() {
            return this.replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(ReplicationType replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getVcenterClientID() {
            return this.vcenterClientID;
        }

        public final void setVcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
        }

        @Override
        public final Builder vcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
            return this;
        }

        public final String getApplicationID() {
            return this.applicationID;
        }

        public final void setApplicationID(String applicationID) {
            this.applicationID = applicationID;
        }

        @Override
        public final Builder applicationID(String applicationID) {
            this.applicationID = applicationID;
            return this;
        }

        public final String getUserProvidedID() {
            return this.userProvidedID;
        }

        public final void setUserProvidedID(String userProvidedID) {
            this.userProvidedID = userProvidedID;
        }

        @Override
        public final Builder userProvidedID(String userProvidedID) {
            this.userProvidedID = userProvidedID;
            return this;
        }

        public final String getFqdnForActionFramework() {
            return this.fqdnForActionFramework;
        }

        public final void setFqdnForActionFramework(String fqdnForActionFramework) {
            this.fqdnForActionFramework = fqdnForActionFramework;
        }

        @Override
        public final Builder fqdnForActionFramework(String fqdnForActionFramework) {
            this.fqdnForActionFramework = fqdnForActionFramework;
            return this;
        }

        public final SourceServerConnectorAction.Builder getConnectorAction() {
            return this.connectorAction != null ? this.connectorAction.toBuilder() : null;
        }

        public final void setConnectorAction(SourceServerConnectorAction.BuilderImpl connectorAction) {
            this.connectorAction = connectorAction != null ? connectorAction.build() : null;
        }

        @Override
        public final Builder connectorAction(SourceServerConnectorAction connectorAction) {
            this.connectorAction = connectorAction;
            return this;
        }

        @Override
        public MarkAsArchivedResponse build() {
            return new MarkAsArchivedResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MarkAsArchivedResponse> {
        public Builder sourceServerID(String var1);

        public Builder arn(String var1);

        public Builder isArchived(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder launchedInstance(LaunchedInstance var1);

        default public Builder launchedInstance(Consumer<LaunchedInstance.Builder> launchedInstance) {
            return this.launchedInstance((LaunchedInstance)((LaunchedInstance.Builder)LaunchedInstance.builder().applyMutation(launchedInstance)).build());
        }

        public Builder dataReplicationInfo(DataReplicationInfo var1);

        default public Builder dataReplicationInfo(Consumer<DataReplicationInfo.Builder> dataReplicationInfo) {
            return this.dataReplicationInfo((DataReplicationInfo)((DataReplicationInfo.Builder)DataReplicationInfo.builder().applyMutation(dataReplicationInfo)).build());
        }

        public Builder lifeCycle(LifeCycle var1);

        default public Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return this.lifeCycle((LifeCycle)((LifeCycle.Builder)LifeCycle.builder().applyMutation(lifeCycle)).build());
        }

        public Builder sourceProperties(SourceProperties var1);

        default public Builder sourceProperties(Consumer<SourceProperties.Builder> sourceProperties) {
            return this.sourceProperties((SourceProperties)((SourceProperties.Builder)SourceProperties.builder().applyMutation(sourceProperties)).build());
        }

        public Builder replicationType(String var1);

        public Builder replicationType(ReplicationType var1);

        public Builder vcenterClientID(String var1);

        public Builder applicationID(String var1);

        public Builder userProvidedID(String var1);

        public Builder fqdnForActionFramework(String var1);

        public Builder connectorAction(SourceServerConnectorAction var1);

        default public Builder connectorAction(Consumer<SourceServerConnectorAction.Builder> connectorAction) {
            return this.connectorAction((SourceServerConnectorAction)((SourceServerConnectorAction.Builder)SourceServerConnectorAction.builder().applyMutation(connectorAction)).build());
        }
    }
}

