/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InternetProtocol {
    IPV4("IPV4"),
    IPV6("IPV6"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InternetProtocol> VALUE_MAP;
    private final String value;

    private InternetProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InternetProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InternetProtocol> knownValues() {
        EnumSet<InternetProtocol> knownValues = EnumSet.allOf(InternetProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InternetProtocol.class, InternetProtocol::toString);
    }
}

