/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTaskSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTaskSummary> {
    private static final SdkField<Long> SERVERS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("serversCount").getter(ExportTaskSummary.getter(ExportTaskSummary::serversCount)).setter(ExportTaskSummary.setter(Builder::serversCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversCount").build()}).build();
    private static final SdkField<Long> APPLICATIONS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("applicationsCount").getter(ExportTaskSummary.getter(ExportTaskSummary::applicationsCount)).setter(ExportTaskSummary.setter(Builder::applicationsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationsCount").build()}).build();
    private static final SdkField<Long> WAVES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("wavesCount").getter(ExportTaskSummary.getter(ExportTaskSummary::wavesCount)).setter(ExportTaskSummary.setter(Builder::wavesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wavesCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERS_COUNT_FIELD, APPLICATIONS_COUNT_FIELD, WAVES_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportTaskSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long serversCount;
    private final Long applicationsCount;
    private final Long wavesCount;

    private ExportTaskSummary(BuilderImpl builder) {
        this.serversCount = builder.serversCount;
        this.applicationsCount = builder.applicationsCount;
        this.wavesCount = builder.wavesCount;
    }

    public final Long serversCount() {
        return this.serversCount;
    }

    public final Long applicationsCount() {
        return this.applicationsCount;
    }

    public final Long wavesCount() {
        return this.wavesCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serversCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.wavesCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskSummary)) {
            return false;
        }
        ExportTaskSummary other = (ExportTaskSummary)obj;
        return Objects.equals(this.serversCount(), other.serversCount()) && Objects.equals(this.applicationsCount(), other.applicationsCount()) && Objects.equals(this.wavesCount(), other.wavesCount());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTaskSummary").add("ServersCount", (Object)this.serversCount()).add("ApplicationsCount", (Object)this.applicationsCount()).add("WavesCount", (Object)this.wavesCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serversCount": {
                return Optional.ofNullable(clazz.cast(this.serversCount()));
            }
            case "applicationsCount": {
                return Optional.ofNullable(clazz.cast(this.applicationsCount()));
            }
            case "wavesCount": {
                return Optional.ofNullable(clazz.cast(this.wavesCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("serversCount", SERVERS_COUNT_FIELD);
        map.put("applicationsCount", APPLICATIONS_COUNT_FIELD);
        map.put("wavesCount", WAVES_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportTaskSummary, T> g) {
        return obj -> g.apply((ExportTaskSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long serversCount;
        private Long applicationsCount;
        private Long wavesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskSummary model) {
            this.serversCount(model.serversCount);
            this.applicationsCount(model.applicationsCount);
            this.wavesCount(model.wavesCount);
        }

        public final Long getServersCount() {
            return this.serversCount;
        }

        public final void setServersCount(Long serversCount) {
            this.serversCount = serversCount;
        }

        @Override
        public final Builder serversCount(Long serversCount) {
            this.serversCount = serversCount;
            return this;
        }

        public final Long getApplicationsCount() {
            return this.applicationsCount;
        }

        public final void setApplicationsCount(Long applicationsCount) {
            this.applicationsCount = applicationsCount;
        }

        @Override
        public final Builder applicationsCount(Long applicationsCount) {
            this.applicationsCount = applicationsCount;
            return this;
        }

        public final Long getWavesCount() {
            return this.wavesCount;
        }

        public final void setWavesCount(Long wavesCount) {
            this.wavesCount = wavesCount;
        }

        @Override
        public final Builder wavesCount(Long wavesCount) {
            this.wavesCount = wavesCount;
            return this;
        }

        public ExportTaskSummary build() {
            return new ExportTaskSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTaskSummary> {
        public Builder serversCount(Long var1);

        public Builder applicationsCount(Long var1);

        public Builder wavesCount(Long var1);
    }
}

