/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.services.mgn.model.StartCutoverRequestSourceServerIDsCopier;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCutoverRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, StartCutoverRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountID").getter(StartCutoverRequest.getter(StartCutoverRequest::accountID)).setter(StartCutoverRequest.setter(Builder::accountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()}).build();
    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceServerIDs").getter(StartCutoverRequest.getter(StartCutoverRequest::sourceServerIDs)).setter(StartCutoverRequest.setter(Builder::sourceServerIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartCutoverRequest.getter(StartCutoverRequest::tags)).setter(StartCutoverRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, SOURCE_SERVER_I_DS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCutoverRequest.memberNameToFieldInitializer();
    private final String accountID;
    private final List<String> sourceServerIDs;
    private final Map<String, String> tags;

    private StartCutoverRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.sourceServerIDs = builder.sourceServerIDs;
        this.tags = builder.tags;
    }

    public final String accountID() {
        return this.accountID;
    }

    public final boolean hasSourceServerIDs() {
        return this.sourceServerIDs != null && !(this.sourceServerIDs instanceof SdkAutoConstructList);
    }

    public final List<String> sourceServerIDs() {
        return this.sourceServerIDs;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServerIDs() ? this.sourceServerIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCutoverRequest)) {
            return false;
        }
        StartCutoverRequest other = (StartCutoverRequest)((Object)obj);
        return Objects.equals(this.accountID(), other.accountID()) && this.hasSourceServerIDs() == other.hasSourceServerIDs() && Objects.equals(this.sourceServerIDs(), other.sourceServerIDs()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartCutoverRequest").add("AccountID", (Object)this.accountID()).add("SourceServerIDs", this.hasSourceServerIDs() ? this.sourceServerIDs() : null).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountID": {
                return Optional.ofNullable(clazz.cast(this.accountID()));
            }
            case "sourceServerIDs": {
                return Optional.ofNullable(clazz.cast(this.sourceServerIDs()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountID", ACCOUNT_ID_FIELD);
        map.put("sourceServerIDs", SOURCE_SERVER_I_DS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCutoverRequest, T> g) {
        return obj -> g.apply((StartCutoverRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String accountID;
        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCutoverRequest model) {
            super(model);
            this.accountID(model.accountID);
            this.sourceServerIDs(model.sourceServerIDs);
            this.tags(model.tags);
        }

        public final String getAccountID() {
            return this.accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final Collection<String> getSourceServerIDs() {
            if (this.sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceServerIDs;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = StartCutoverRequestSourceServerIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = StartCutoverRequestSourceServerIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String ... sourceServerIDs) {
            this.sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCutoverRequest build() {
            return new StartCutoverRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCutoverRequest> {
        public Builder accountID(String var1);

        public Builder sourceServerIDs(Collection<String> var1);

        public Builder sourceServerIDs(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

