/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.ApplicationAggregatedStatus;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Application
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Application> {
    private static final SdkField<ApplicationAggregatedStatus> APPLICATION_AGGREGATED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("applicationAggregatedStatus").getter(Application.getter(Application::applicationAggregatedStatus)).setter(Application.setter(Builder::applicationAggregatedStatus)).constructor(ApplicationAggregatedStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationAggregatedStatus").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationID").getter(Application.getter(Application::applicationID)).setter(Application.setter(Builder::applicationID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationID").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Application.getter(Application::arn)).setter(Application.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationDateTime").getter(Application.getter(Application::creationDateTime)).setter(Application.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Application.getter(Application::description)).setter(Application.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(Application.getter(Application::isArchived)).setter(Application.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedDateTime").getter(Application.getter(Application::lastModifiedDateTime)).setter(Application.setter(Builder::lastModifiedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDateTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Application.getter(Application::name)).setter(Application.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Application.getter(Application::tags)).setter(Application.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WAVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("waveID").getter(Application.getter(Application::waveID)).setter(Application.setter(Builder::waveID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_AGGREGATED_STATUS_FIELD, APPLICATION_ID_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, IS_ARCHIVED_FIELD, LAST_MODIFIED_DATE_TIME_FIELD, NAME_FIELD, TAGS_FIELD, WAVE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Application.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ApplicationAggregatedStatus applicationAggregatedStatus;
    private final String applicationID;
    private final String arn;
    private final String creationDateTime;
    private final String description;
    private final Boolean isArchived;
    private final String lastModifiedDateTime;
    private final String name;
    private final Map<String, String> tags;
    private final String waveID;

    private Application(BuilderImpl builder) {
        this.applicationAggregatedStatus = builder.applicationAggregatedStatus;
        this.applicationID = builder.applicationID;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.isArchived = builder.isArchived;
        this.lastModifiedDateTime = builder.lastModifiedDateTime;
        this.name = builder.name;
        this.tags = builder.tags;
        this.waveID = builder.waveID;
    }

    public final ApplicationAggregatedStatus applicationAggregatedStatus() {
        return this.applicationAggregatedStatus;
    }

    public final String applicationID() {
        return this.applicationID;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationDateTime() {
        return this.creationDateTime;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final String lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String waveID() {
        return this.waveID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationAggregatedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationID());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waveID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        return Objects.equals(this.applicationAggregatedStatus(), other.applicationAggregatedStatus()) && Objects.equals(this.applicationID(), other.applicationID()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isArchived(), other.isArchived()) && Objects.equals(this.lastModifiedDateTime(), other.lastModifiedDateTime()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.waveID(), other.waveID());
    }

    public final String toString() {
        return ToString.builder((String)"Application").add("ApplicationAggregatedStatus", (Object)this.applicationAggregatedStatus()).add("ApplicationID", (Object)this.applicationID()).add("Arn", (Object)this.arn()).add("CreationDateTime", (Object)this.creationDateTime()).add("Description", (Object)this.description()).add("IsArchived", (Object)this.isArchived()).add("LastModifiedDateTime", (Object)this.lastModifiedDateTime()).add("Name", (Object)this.name()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("WaveID", (Object)this.waveID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationAggregatedStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationAggregatedStatus()));
            }
            case "applicationID": {
                return Optional.ofNullable(clazz.cast(this.applicationID()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "lastModifiedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDateTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "waveID": {
                return Optional.ofNullable(clazz.cast(this.waveID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationAggregatedStatus", APPLICATION_AGGREGATED_STATUS_FIELD);
        map.put("applicationID", APPLICATION_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("lastModifiedDateTime", LAST_MODIFIED_DATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("waveID", WAVE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ApplicationAggregatedStatus applicationAggregatedStatus;
        private String applicationID;
        private String arn;
        private String creationDateTime;
        private String description;
        private Boolean isArchived;
        private String lastModifiedDateTime;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String waveID;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            this.applicationAggregatedStatus(model.applicationAggregatedStatus);
            this.applicationID(model.applicationID);
            this.arn(model.arn);
            this.creationDateTime(model.creationDateTime);
            this.description(model.description);
            this.isArchived(model.isArchived);
            this.lastModifiedDateTime(model.lastModifiedDateTime);
            this.name(model.name);
            this.tags(model.tags);
            this.waveID(model.waveID);
        }

        public final ApplicationAggregatedStatus.Builder getApplicationAggregatedStatus() {
            return this.applicationAggregatedStatus != null ? this.applicationAggregatedStatus.toBuilder() : null;
        }

        public final void setApplicationAggregatedStatus(ApplicationAggregatedStatus.BuilderImpl applicationAggregatedStatus) {
            this.applicationAggregatedStatus = applicationAggregatedStatus != null ? applicationAggregatedStatus.build() : null;
        }

        @Override
        public final Builder applicationAggregatedStatus(ApplicationAggregatedStatus applicationAggregatedStatus) {
            this.applicationAggregatedStatus = applicationAggregatedStatus;
            return this;
        }

        public final String getApplicationID() {
            return this.applicationID;
        }

        public final void setApplicationID(String applicationID) {
            this.applicationID = applicationID;
        }

        @Override
        public final Builder applicationID(String applicationID) {
            this.applicationID = applicationID;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final String getLastModifiedDateTime() {
            return this.lastModifiedDateTime;
        }

        public final void setLastModifiedDateTime(String lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }

        @Override
        public final Builder lastModifiedDateTime(String lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getWaveID() {
            return this.waveID;
        }

        public final void setWaveID(String waveID) {
            this.waveID = waveID;
        }

        @Override
        public final Builder waveID(String waveID) {
            this.waveID = waveID;
            return this;
        }

        public Application build() {
            return new Application(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Application> {
        public Builder applicationAggregatedStatus(ApplicationAggregatedStatus var1);

        default public Builder applicationAggregatedStatus(Consumer<ApplicationAggregatedStatus.Builder> applicationAggregatedStatus) {
            return this.applicationAggregatedStatus((ApplicationAggregatedStatus)((ApplicationAggregatedStatus.Builder)ApplicationAggregatedStatus.builder().applyMutation(applicationAggregatedStatus)).build());
        }

        public Builder applicationID(String var1);

        public Builder arn(String var1);

        public Builder creationDateTime(String var1);

        public Builder description(String var1);

        public Builder isArchived(Boolean var1);

        public Builder lastModifiedDateTime(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder waveID(String var1);
    }
}

