/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionCategory {
    DISASTER_RECOVERY("DISASTER_RECOVERY"),
    OPERATING_SYSTEM("OPERATING_SYSTEM"),
    LICENSE_AND_SUBSCRIPTION("LICENSE_AND_SUBSCRIPTION"),
    VALIDATION("VALIDATION"),
    OBSERVABILITY("OBSERVABILITY"),
    REFACTORING("REFACTORING"),
    SECURITY("SECURITY"),
    NETWORKING("NETWORKING"),
    CONFIGURATION("CONFIGURATION"),
    BACKUP("BACKUP"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionCategory> VALUE_MAP;
    private final String value;

    private ActionCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionCategory> knownValues() {
        EnumSet<ActionCategory> knownValues = EnumSet.allOf(ActionCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionCategory.class, ActionCategory::toString);
    }
}

