/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ListWavesRequest;
import software.amazon.awssdk.services.mgn.model.ListWavesResponse;
import software.amazon.awssdk.services.mgn.model.Wave;

public class ListWavesIterable
implements SdkIterable<ListWavesResponse> {
    private final MgnClient client;
    private final ListWavesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWavesIterable(MgnClient client, ListWavesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWavesResponseFetcher();
    }

    public Iterator<ListWavesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Wave> items() {
        Function<ListWavesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWavesResponseFetcher
    implements SyncPageFetcher<ListWavesResponse> {
        private ListWavesResponseFetcher() {
        }

        public boolean hasNextPage(ListWavesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWavesResponse nextPage(ListWavesResponse previousPage) {
            if (previousPage == null) {
                return ListWavesIterable.this.client.listWaves(ListWavesIterable.this.firstRequest);
            }
            return ListWavesIterable.this.client.listWaves((ListWavesRequest)((Object)ListWavesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

