/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.ListExportsRequestFiltersExportIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExportsRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListExportsRequestFilters> {
    private static final SdkField<List<String>> EXPORT_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportIDs").getter(ListExportsRequestFilters.getter(ListExportsRequestFilters::exportIDs)).setter(ListExportsRequestFilters.setter(Builder::exportIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_I_DS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExportsRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> exportIDs;

    private ListExportsRequestFilters(BuilderImpl builder) {
        this.exportIDs = builder.exportIDs;
    }

    public final boolean hasExportIDs() {
        return this.exportIDs != null && !(this.exportIDs instanceof SdkAutoConstructList);
    }

    public final List<String> exportIDs() {
        return this.exportIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportIDs() ? this.exportIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsRequestFilters)) {
            return false;
        }
        ListExportsRequestFilters other = (ListExportsRequestFilters)obj;
        return this.hasExportIDs() == other.hasExportIDs() && Objects.equals(this.exportIDs(), other.exportIDs());
    }

    public final String toString() {
        return ToString.builder((String)"ListExportsRequestFilters").add("ExportIDs", this.hasExportIDs() ? this.exportIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportIDs": {
                return Optional.ofNullable(clazz.cast(this.exportIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("exportIDs", EXPORT_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExportsRequestFilters, T> g) {
        return obj -> g.apply((ListExportsRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> exportIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsRequestFilters model) {
            this.exportIDs(model.exportIDs);
        }

        public final Collection<String> getExportIDs() {
            if (this.exportIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportIDs;
        }

        public final void setExportIDs(Collection<String> exportIDs) {
            this.exportIDs = ListExportsRequestFiltersExportIDsCopier.copy(exportIDs);
        }

        @Override
        public final Builder exportIDs(Collection<String> exportIDs) {
            this.exportIDs = ListExportsRequestFiltersExportIDsCopier.copy(exportIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportIDs(String ... exportIDs) {
            this.exportIDs(Arrays.asList(exportIDs));
            return this;
        }

        public ListExportsRequestFilters build() {
            return new ListExportsRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListExportsRequestFilters> {
        public Builder exportIDs(Collection<String> var1);

        public Builder exportIDs(String ... var1);
    }
}

