/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.DataReplicationInfo;
import software.amazon.awssdk.services.mgn.model.LaunchedInstance;
import software.amazon.awssdk.services.mgn.model.LifeCycle;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.ReplicationType;
import software.amazon.awssdk.services.mgn.model.SourceProperties;
import software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeServerLifeCycleStateResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, ChangeServerLifeCycleStateResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationID").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::applicationID)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::applicationID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationID").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::arn)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<SourceServerConnectorAction> CONNECTOR_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorAction").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::connectorAction)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::connectorAction)).constructor(SourceServerConnectorAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorAction").build()}).build();
    private static final SdkField<DataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationInfo").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::dataReplicationInfo)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::dataReplicationInfo)).constructor(DataReplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build()}).build();
    private static final SdkField<String> FQDN_FOR_ACTION_FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fqdnForActionFramework").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::fqdnForActionFramework)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::fqdnForActionFramework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fqdnForActionFramework").build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::isArchived)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<LaunchedInstance> LAUNCHED_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchedInstance").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::launchedInstance)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::launchedInstance)).constructor(LaunchedInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedInstance").build()}).build();
    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifeCycle").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::lifeCycle)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::lifeCycle)).constructor(LifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()}).build();
    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationType").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::replicationTypeAsString)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::replicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationType").build()}).build();
    private static final SdkField<SourceProperties> SOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceProperties").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::sourceProperties)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::sourceProperties)).constructor(SourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::sourceServerID)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::tags)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> USER_PROVIDED_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userProvidedID").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::userProvidedID)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::userProvidedID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProvidedID").build()}).build();
    private static final SdkField<String> VCENTER_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vcenterClientID").getter(ChangeServerLifeCycleStateResponse.getter(ChangeServerLifeCycleStateResponse::vcenterClientID)).setter(ChangeServerLifeCycleStateResponse.setter(Builder::vcenterClientID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterClientID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ARN_FIELD, CONNECTOR_ACTION_FIELD, DATA_REPLICATION_INFO_FIELD, FQDN_FOR_ACTION_FRAMEWORK_FIELD, IS_ARCHIVED_FIELD, LAUNCHED_INSTANCE_FIELD, LIFE_CYCLE_FIELD, REPLICATION_TYPE_FIELD, SOURCE_PROPERTIES_FIELD, SOURCE_SERVER_ID_FIELD, TAGS_FIELD, USER_PROVIDED_ID_FIELD, VCENTER_CLIENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeServerLifeCycleStateResponse.memberNameToFieldInitializer();
    private final String applicationID;
    private final String arn;
    private final SourceServerConnectorAction connectorAction;
    private final DataReplicationInfo dataReplicationInfo;
    private final String fqdnForActionFramework;
    private final Boolean isArchived;
    private final LaunchedInstance launchedInstance;
    private final LifeCycle lifeCycle;
    private final String replicationType;
    private final SourceProperties sourceProperties;
    private final String sourceServerID;
    private final Map<String, String> tags;
    private final String userProvidedID;
    private final String vcenterClientID;

    private ChangeServerLifeCycleStateResponse(BuilderImpl builder) {
        super(builder);
        this.applicationID = builder.applicationID;
        this.arn = builder.arn;
        this.connectorAction = builder.connectorAction;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.fqdnForActionFramework = builder.fqdnForActionFramework;
        this.isArchived = builder.isArchived;
        this.launchedInstance = builder.launchedInstance;
        this.lifeCycle = builder.lifeCycle;
        this.replicationType = builder.replicationType;
        this.sourceProperties = builder.sourceProperties;
        this.sourceServerID = builder.sourceServerID;
        this.tags = builder.tags;
        this.userProvidedID = builder.userProvidedID;
        this.vcenterClientID = builder.vcenterClientID;
    }

    public final String applicationID() {
        return this.applicationID;
    }

    public final String arn() {
        return this.arn;
    }

    public final SourceServerConnectorAction connectorAction() {
        return this.connectorAction;
    }

    public final DataReplicationInfo dataReplicationInfo() {
        return this.dataReplicationInfo;
    }

    public final String fqdnForActionFramework() {
        return this.fqdnForActionFramework;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final LaunchedInstance launchedInstance() {
        return this.launchedInstance;
    }

    public final LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public final ReplicationType replicationType() {
        return ReplicationType.fromValue(this.replicationType);
    }

    public final String replicationTypeAsString() {
        return this.replicationType;
    }

    public final SourceProperties sourceProperties() {
        return this.sourceProperties;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String userProvidedID() {
        return this.userProvidedID;
    }

    public final String vcenterClientID() {
        return this.vcenterClientID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationID());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.fqdnForActionFramework());
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userProvidedID());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcenterClientID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeServerLifeCycleStateResponse)) {
            return false;
        }
        ChangeServerLifeCycleStateResponse other = (ChangeServerLifeCycleStateResponse)((Object)obj);
        return Objects.equals(this.applicationID(), other.applicationID()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.connectorAction(), other.connectorAction()) && Objects.equals(this.dataReplicationInfo(), other.dataReplicationInfo()) && Objects.equals(this.fqdnForActionFramework(), other.fqdnForActionFramework()) && Objects.equals(this.isArchived(), other.isArchived()) && Objects.equals(this.launchedInstance(), other.launchedInstance()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.replicationTypeAsString(), other.replicationTypeAsString()) && Objects.equals(this.sourceProperties(), other.sourceProperties()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.userProvidedID(), other.userProvidedID()) && Objects.equals(this.vcenterClientID(), other.vcenterClientID());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeServerLifeCycleStateResponse").add("ApplicationID", (Object)this.applicationID()).add("Arn", (Object)this.arn()).add("ConnectorAction", (Object)this.connectorAction()).add("DataReplicationInfo", (Object)this.dataReplicationInfo()).add("FqdnForActionFramework", (Object)this.fqdnForActionFramework()).add("IsArchived", (Object)this.isArchived()).add("LaunchedInstance", (Object)this.launchedInstance()).add("LifeCycle", (Object)this.lifeCycle()).add("ReplicationType", (Object)this.replicationTypeAsString()).add("SourceProperties", (Object)this.sourceProperties()).add("SourceServerID", (Object)this.sourceServerID()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UserProvidedID", (Object)this.userProvidedID()).add("VcenterClientID", (Object)this.vcenterClientID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationID": {
                return Optional.ofNullable(clazz.cast(this.applicationID()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "connectorAction": {
                return Optional.ofNullable(clazz.cast(this.connectorAction()));
            }
            case "dataReplicationInfo": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationInfo()));
            }
            case "fqdnForActionFramework": {
                return Optional.ofNullable(clazz.cast(this.fqdnForActionFramework()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "launchedInstance": {
                return Optional.ofNullable(clazz.cast(this.launchedInstance()));
            }
            case "lifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "replicationType": {
                return Optional.ofNullable(clazz.cast(this.replicationTypeAsString()));
            }
            case "sourceProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProperties()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "userProvidedID": {
                return Optional.ofNullable(clazz.cast(this.userProvidedID()));
            }
            case "vcenterClientID": {
                return Optional.ofNullable(clazz.cast(this.vcenterClientID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationID", APPLICATION_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("connectorAction", CONNECTOR_ACTION_FIELD);
        map.put("dataReplicationInfo", DATA_REPLICATION_INFO_FIELD);
        map.put("fqdnForActionFramework", FQDN_FOR_ACTION_FRAMEWORK_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("launchedInstance", LAUNCHED_INSTANCE_FIELD);
        map.put("lifeCycle", LIFE_CYCLE_FIELD);
        map.put("replicationType", REPLICATION_TYPE_FIELD);
        map.put("sourceProperties", SOURCE_PROPERTIES_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("userProvidedID", USER_PROVIDED_ID_FIELD);
        map.put("vcenterClientID", VCENTER_CLIENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeServerLifeCycleStateResponse, T> g) {
        return obj -> g.apply((ChangeServerLifeCycleStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private String applicationID;
        private String arn;
        private SourceServerConnectorAction connectorAction;
        private DataReplicationInfo dataReplicationInfo;
        private String fqdnForActionFramework;
        private Boolean isArchived;
        private LaunchedInstance launchedInstance;
        private LifeCycle lifeCycle;
        private String replicationType;
        private SourceProperties sourceProperties;
        private String sourceServerID;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String userProvidedID;
        private String vcenterClientID;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeServerLifeCycleStateResponse model) {
            super(model);
            this.applicationID(model.applicationID);
            this.arn(model.arn);
            this.connectorAction(model.connectorAction);
            this.dataReplicationInfo(model.dataReplicationInfo);
            this.fqdnForActionFramework(model.fqdnForActionFramework);
            this.isArchived(model.isArchived);
            this.launchedInstance(model.launchedInstance);
            this.lifeCycle(model.lifeCycle);
            this.replicationType(model.replicationType);
            this.sourceProperties(model.sourceProperties);
            this.sourceServerID(model.sourceServerID);
            this.tags(model.tags);
            this.userProvidedID(model.userProvidedID);
            this.vcenterClientID(model.vcenterClientID);
        }

        public final String getApplicationID() {
            return this.applicationID;
        }

        public final void setApplicationID(String applicationID) {
            this.applicationID = applicationID;
        }

        @Override
        public final Builder applicationID(String applicationID) {
            this.applicationID = applicationID;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final SourceServerConnectorAction.Builder getConnectorAction() {
            return this.connectorAction != null ? this.connectorAction.toBuilder() : null;
        }

        public final void setConnectorAction(SourceServerConnectorAction.BuilderImpl connectorAction) {
            this.connectorAction = connectorAction != null ? connectorAction.build() : null;
        }

        @Override
        public final Builder connectorAction(SourceServerConnectorAction connectorAction) {
            this.connectorAction = connectorAction;
            return this;
        }

        public final DataReplicationInfo.Builder getDataReplicationInfo() {
            return this.dataReplicationInfo != null ? this.dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(DataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        public final Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final String getFqdnForActionFramework() {
            return this.fqdnForActionFramework;
        }

        public final void setFqdnForActionFramework(String fqdnForActionFramework) {
            this.fqdnForActionFramework = fqdnForActionFramework;
        }

        @Override
        public final Builder fqdnForActionFramework(String fqdnForActionFramework) {
            this.fqdnForActionFramework = fqdnForActionFramework;
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final LaunchedInstance.Builder getLaunchedInstance() {
            return this.launchedInstance != null ? this.launchedInstance.toBuilder() : null;
        }

        public final void setLaunchedInstance(LaunchedInstance.BuilderImpl launchedInstance) {
            this.launchedInstance = launchedInstance != null ? launchedInstance.build() : null;
        }

        @Override
        public final Builder launchedInstance(LaunchedInstance launchedInstance) {
            this.launchedInstance = launchedInstance;
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getReplicationType() {
            return this.replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(ReplicationType replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final SourceProperties.Builder getSourceProperties() {
            return this.sourceProperties != null ? this.sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getUserProvidedID() {
            return this.userProvidedID;
        }

        public final void setUserProvidedID(String userProvidedID) {
            this.userProvidedID = userProvidedID;
        }

        @Override
        public final Builder userProvidedID(String userProvidedID) {
            this.userProvidedID = userProvidedID;
            return this;
        }

        public final String getVcenterClientID() {
            return this.vcenterClientID;
        }

        public final void setVcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
        }

        @Override
        public final Builder vcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
            return this;
        }

        @Override
        public ChangeServerLifeCycleStateResponse build() {
            return new ChangeServerLifeCycleStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangeServerLifeCycleStateResponse> {
        public Builder applicationID(String var1);

        public Builder arn(String var1);

        public Builder connectorAction(SourceServerConnectorAction var1);

        default public Builder connectorAction(Consumer<SourceServerConnectorAction.Builder> connectorAction) {
            return this.connectorAction((SourceServerConnectorAction)((SourceServerConnectorAction.Builder)SourceServerConnectorAction.builder().applyMutation(connectorAction)).build());
        }

        public Builder dataReplicationInfo(DataReplicationInfo var1);

        default public Builder dataReplicationInfo(Consumer<DataReplicationInfo.Builder> dataReplicationInfo) {
            return this.dataReplicationInfo((DataReplicationInfo)((DataReplicationInfo.Builder)DataReplicationInfo.builder().applyMutation(dataReplicationInfo)).build());
        }

        public Builder fqdnForActionFramework(String var1);

        public Builder isArchived(Boolean var1);

        public Builder launchedInstance(LaunchedInstance var1);

        default public Builder launchedInstance(Consumer<LaunchedInstance.Builder> launchedInstance) {
            return this.launchedInstance((LaunchedInstance)((LaunchedInstance.Builder)LaunchedInstance.builder().applyMutation(launchedInstance)).build());
        }

        public Builder lifeCycle(LifeCycle var1);

        default public Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return this.lifeCycle((LifeCycle)((LifeCycle.Builder)LifeCycle.builder().applyMutation(lifeCycle)).build());
        }

        public Builder replicationType(String var1);

        public Builder replicationType(ReplicationType var1);

        public Builder sourceProperties(SourceProperties var1);

        default public Builder sourceProperties(Consumer<SourceProperties.Builder> sourceProperties) {
            return this.sourceProperties((SourceProperties)((SourceProperties.Builder)SourceProperties.builder().applyMutation(sourceProperties)).build());
        }

        public Builder sourceServerID(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder userProvidedID(String var1);

        public Builder vcenterClientID(String var1);
    }
}

