/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineVersionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineVersionInfo> {
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(EngineVersionInfo.getter(EngineVersionInfo::engineVersion)).setter(EngineVersionInfo.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> ENGINE_PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnginePatchVersion").getter(EngineVersionInfo.getter(EngineVersionInfo::enginePatchVersion)).setter(EngineVersionInfo.setter(Builder::enginePatchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnginePatchVersion").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupFamily").getter(EngineVersionInfo.getter(EngineVersionInfo::parameterGroupFamily)).setter(EngineVersionInfo.setter(Builder::parameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupFamily").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD, ENGINE_PATCH_VERSION_FIELD, PARAMETER_GROUP_FAMILY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engineVersion;
    private final String enginePatchVersion;
    private final String parameterGroupFamily;

    private EngineVersionInfo(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.enginePatchVersion = builder.enginePatchVersion;
        this.parameterGroupFamily = builder.parameterGroupFamily;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String enginePatchVersion() {
        return this.enginePatchVersion;
    }

    public final String parameterGroupFamily() {
        return this.parameterGroupFamily;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.enginePatchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupFamily());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineVersionInfo)) {
            return false;
        }
        EngineVersionInfo other = (EngineVersionInfo)obj;
        return Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.enginePatchVersion(), other.enginePatchVersion()) && Objects.equals(this.parameterGroupFamily(), other.parameterGroupFamily());
    }

    public final String toString() {
        return ToString.builder((String)"EngineVersionInfo").add("EngineVersion", (Object)this.engineVersion()).add("EnginePatchVersion", (Object)this.enginePatchVersion()).add("ParameterGroupFamily", (Object)this.parameterGroupFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "EnginePatchVersion": {
                return Optional.ofNullable(clazz.cast(this.enginePatchVersion()));
            }
            case "ParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupFamily()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineVersionInfo, T> g) {
        return obj -> g.apply((EngineVersionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineVersion;
        private String enginePatchVersion;
        private String parameterGroupFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineVersionInfo model) {
            this.engineVersion(model.engineVersion);
            this.enginePatchVersion(model.enginePatchVersion);
            this.parameterGroupFamily(model.parameterGroupFamily);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnginePatchVersion() {
            return this.enginePatchVersion;
        }

        public final void setEnginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
        }

        @Override
        @Transient
        public final Builder enginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
            return this;
        }

        public final String getParameterGroupFamily() {
            return this.parameterGroupFamily;
        }

        public final void setParameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
        }

        @Override
        @Transient
        public final Builder parameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
            return this;
        }

        public EngineVersionInfo build() {
            return new EngineVersionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineVersionInfo> {
        public Builder engineVersion(String var1);

        public Builder enginePatchVersion(String var1);

        public Builder parameterGroupFamily(String var1);
    }
}

