/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverShardRequest extends MemoryDbRequest implements
        ToCopyableBuilder<FailoverShardRequest.Builder, FailoverShardRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(FailoverShardRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> SHARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShardName").getter(getter(FailoverShardRequest::shardName)).setter(setter(Builder::shardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            SHARD_NAME_FIELD));

    private final String clusterName;

    private final String shardName;

    private FailoverShardRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.shardName = builder.shardName;
    }

    /**
     * <p>
     * The cluster being failed over
     * </p>
     * 
     * @return The cluster being failed over
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the shard
     * </p>
     * 
     * @return The name of the shard
     */
    public final String shardName() {
        return shardName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(shardName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverShardRequest)) {
            return false;
        }
        FailoverShardRequest other = (FailoverShardRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(shardName(), other.shardName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverShardRequest").add("ClusterName", clusterName()).add("ShardName", shardName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "ShardName":
            return Optional.ofNullable(clazz.cast(shardName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverShardRequest, T> g) {
        return obj -> g.apply((FailoverShardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, FailoverShardRequest> {
        /**
         * <p>
         * The cluster being failed over
         * </p>
         * 
         * @param clusterName
         *        The cluster being failed over
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the shard
         * </p>
         * 
         * @param shardName
         *        The name of the shard
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardName(String shardName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String shardName;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverShardRequest model) {
            super(model);
            clusterName(model.clusterName);
            shardName(model.shardName);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        @Transient
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getShardName() {
            return shardName;
        }

        public final void setShardName(String shardName) {
            this.shardName = shardName;
        }

        @Override
        @Transient
        public final Builder shardName(String shardName) {
            this.shardName = shardName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FailoverShardRequest build() {
            return new FailoverShardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
