/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetState;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetWorkflowStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopySourceImageSetProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CopySourceImageSetProperties> {
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetId").getter(CopySourceImageSetProperties.getter(CopySourceImageSetProperties::imageSetId)).setter(CopySourceImageSetProperties.setter(Builder::imageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()}).build();
    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestVersionId").getter(CopySourceImageSetProperties.getter(CopySourceImageSetProperties::latestVersionId)).setter(CopySourceImageSetProperties.setter(Builder::latestVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionId").build()}).build();
    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetState").getter(CopySourceImageSetProperties.getter(CopySourceImageSetProperties::imageSetStateAsString)).setter(CopySourceImageSetProperties.setter(Builder::imageSetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()}).build();
    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetWorkflowStatus").getter(CopySourceImageSetProperties.getter(CopySourceImageSetProperties::imageSetWorkflowStatusAsString)).setter(CopySourceImageSetProperties.setter(Builder::imageSetWorkflowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CopySourceImageSetProperties.getter(CopySourceImageSetProperties::createdAt)).setter(CopySourceImageSetProperties.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(CopySourceImageSetProperties.getter(CopySourceImageSetProperties::updatedAt)).setter(CopySourceImageSetProperties.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> IMAGE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetArn").getter(CopySourceImageSetProperties.getter(CopySourceImageSetProperties::imageSetArn)).setter(CopySourceImageSetProperties.setter(Builder::imageSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SET_ID_FIELD, LATEST_VERSION_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, IMAGE_SET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopySourceImageSetProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String imageSetId;
    private final String latestVersionId;
    private final String imageSetState;
    private final String imageSetWorkflowStatus;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String imageSetArn;

    private CopySourceImageSetProperties(BuilderImpl builder) {
        this.imageSetId = builder.imageSetId;
        this.latestVersionId = builder.latestVersionId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.imageSetArn = builder.imageSetArn;
    }

    public final String imageSetId() {
        return this.imageSetId;
    }

    public final String latestVersionId() {
        return this.latestVersionId;
    }

    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(this.imageSetState);
    }

    public final String imageSetStateAsString() {
        return this.imageSetState;
    }

    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(this.imageSetWorkflowStatus);
    }

    public final String imageSetWorkflowStatusAsString() {
        return this.imageSetWorkflowStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String imageSetArn() {
        return this.imageSetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetWorkflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySourceImageSetProperties)) {
            return false;
        }
        CopySourceImageSetProperties other = (CopySourceImageSetProperties)obj;
        return Objects.equals(this.imageSetId(), other.imageSetId()) && Objects.equals(this.latestVersionId(), other.latestVersionId()) && Objects.equals(this.imageSetStateAsString(), other.imageSetStateAsString()) && Objects.equals(this.imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.imageSetArn(), other.imageSetArn());
    }

    public final String toString() {
        return ToString.builder((String)"CopySourceImageSetProperties").add("ImageSetId", (Object)this.imageSetId()).add("LatestVersionId", (Object)this.latestVersionId()).add("ImageSetState", (Object)this.imageSetStateAsString()).add("ImageSetWorkflowStatus", (Object)this.imageSetWorkflowStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ImageSetArn", (Object)this.imageSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageSetId": {
                return Optional.ofNullable(clazz.cast(this.imageSetId()));
            }
            case "latestVersionId": {
                return Optional.ofNullable(clazz.cast(this.latestVersionId()));
            }
            case "imageSetState": {
                return Optional.ofNullable(clazz.cast(this.imageSetStateAsString()));
            }
            case "imageSetWorkflowStatus": {
                return Optional.ofNullable(clazz.cast(this.imageSetWorkflowStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "imageSetArn": {
                return Optional.ofNullable(clazz.cast(this.imageSetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imageSetId", IMAGE_SET_ID_FIELD);
        map.put("latestVersionId", LATEST_VERSION_ID_FIELD);
        map.put("imageSetState", IMAGE_SET_STATE_FIELD);
        map.put("imageSetWorkflowStatus", IMAGE_SET_WORKFLOW_STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("imageSetArn", IMAGE_SET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopySourceImageSetProperties, T> g) {
        return obj -> g.apply((CopySourceImageSetProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageSetId;
        private String latestVersionId;
        private String imageSetState;
        private String imageSetWorkflowStatus;
        private Instant createdAt;
        private Instant updatedAt;
        private String imageSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySourceImageSetProperties model) {
            this.imageSetId(model.imageSetId);
            this.latestVersionId(model.latestVersionId);
            this.imageSetState(model.imageSetState);
            this.imageSetWorkflowStatus(model.imageSetWorkflowStatus);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.imageSetArn(model.imageSetArn);
        }

        public final String getImageSetId() {
            return this.imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getLatestVersionId() {
            return this.latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final String getImageSetState() {
            return this.imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return this.imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getImageSetArn() {
            return this.imageSetArn;
        }

        public final void setImageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
        }

        @Override
        public final Builder imageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
            return this;
        }

        public CopySourceImageSetProperties build() {
            return new CopySourceImageSetProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CopySourceImageSetProperties> {
        public Builder imageSetId(String var1);

        public Builder latestVersionId(String var1);

        public Builder imageSetState(String var1);

        public Builder imageSetState(ImageSetState var1);

        public Builder imageSetWorkflowStatus(String var1);

        public Builder imageSetWorkflowStatus(ImageSetWorkflowStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder imageSetArn(String var1);
    }
}

