/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingAsyncClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetProperties;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsResponse;

public class ListImageSetVersionsPublisher
implements SdkPublisher<ListImageSetVersionsResponse> {
    private final MedicalImagingAsyncClient client;
    private final ListImageSetVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImageSetVersionsPublisher(MedicalImagingAsyncClient client, ListImageSetVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImageSetVersionsPublisher(MedicalImagingAsyncClient client, ListImageSetVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImageSetVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImageSetVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageSetProperties> imageSetPropertiesList() {
        Function<ListImageSetVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageSetPropertiesList() != null) {
                return response.imageSetPropertiesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImageSetVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImageSetVersionsResponseFetcher
    implements AsyncPageFetcher<ListImageSetVersionsResponse> {
        private ListImageSetVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageSetVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImageSetVersionsResponse> nextPage(ListImageSetVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListImageSetVersionsPublisher.this.client.listImageSetVersions(ListImageSetVersionsPublisher.this.firstRequest);
            }
            return ListImageSetVersionsPublisher.this.client.listImageSetVersions((ListImageSetVersionsRequest)((Object)ListImageSetVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

