/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DICOMUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DICOMUpdates> {
    private static final SdkField<SdkBytes> REMOVABLE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("removableAttributes").getter(DICOMUpdates.getter(DICOMUpdates::removableAttributes)).setter(DICOMUpdates.setter(Builder::removableAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removableAttributes").build()}).build();
    private static final SdkField<SdkBytes> UPDATABLE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("updatableAttributes").getter(DICOMUpdates.getter(DICOMUpdates::updatableAttributes)).setter(DICOMUpdates.setter(Builder::updatableAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatableAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOVABLE_ATTRIBUTES_FIELD, UPDATABLE_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DICOMUpdates.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes removableAttributes;
    private final SdkBytes updatableAttributes;

    private DICOMUpdates(BuilderImpl builder) {
        this.removableAttributes = builder.removableAttributes;
        this.updatableAttributes = builder.updatableAttributes;
    }

    public final SdkBytes removableAttributes() {
        return this.removableAttributes;
    }

    public final SdkBytes updatableAttributes() {
        return this.updatableAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.removableAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatableAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DICOMUpdates)) {
            return false;
        }
        DICOMUpdates other = (DICOMUpdates)obj;
        return Objects.equals(this.removableAttributes(), other.removableAttributes()) && Objects.equals(this.updatableAttributes(), other.updatableAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DICOMUpdates").add("RemovableAttributes", (Object)(this.removableAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("UpdatableAttributes", (Object)(this.updatableAttributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "removableAttributes": {
                return Optional.ofNullable(clazz.cast(this.removableAttributes()));
            }
            case "updatableAttributes": {
                return Optional.ofNullable(clazz.cast(this.updatableAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkBytes>> map = new HashMap<String, SdkField<SdkBytes>>();
        map.put("removableAttributes", REMOVABLE_ATTRIBUTES_FIELD);
        map.put("updatableAttributes", UPDATABLE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DICOMUpdates, T> g) {
        return obj -> g.apply((DICOMUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes removableAttributes;
        private SdkBytes updatableAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DICOMUpdates model) {
            this.removableAttributes(model.removableAttributes);
            this.updatableAttributes(model.updatableAttributes);
        }

        public final ByteBuffer getRemovableAttributes() {
            return this.removableAttributes == null ? null : this.removableAttributes.asByteBuffer();
        }

        public final void setRemovableAttributes(ByteBuffer removableAttributes) {
            this.removableAttributes(removableAttributes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)removableAttributes));
        }

        @Override
        public final Builder removableAttributes(SdkBytes removableAttributes) {
            this.removableAttributes = removableAttributes;
            return this;
        }

        public final ByteBuffer getUpdatableAttributes() {
            return this.updatableAttributes == null ? null : this.updatableAttributes.asByteBuffer();
        }

        public final void setUpdatableAttributes(ByteBuffer updatableAttributes) {
            this.updatableAttributes(updatableAttributes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)updatableAttributes));
        }

        @Override
        public final Builder updatableAttributes(SdkBytes updatableAttributes) {
            this.updatableAttributes = updatableAttributes;
            return this;
        }

        public DICOMUpdates build() {
            return new DICOMUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DICOMUpdates> {
        public Builder removableAttributes(SdkBytes var1);

        public Builder updatableAttributes(SdkBytes var1);
    }
}

