/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummary;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsRequest;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsResponse;

public class SearchImageSetsIterable
implements SdkIterable<SearchImageSetsResponse> {
    private final MedicalImagingClient client;
    private final SearchImageSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchImageSetsIterable(MedicalImagingClient client, SearchImageSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchImageSetsResponseFetcher();
    }

    public Iterator<SearchImageSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageSetsMetadataSummary> imageSetsMetadataSummaries() {
        Function<SearchImageSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageSetsMetadataSummaries() != null) {
                return response.imageSetsMetadataSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchImageSetsResponseFetcher
    implements SyncPageFetcher<SearchImageSetsResponse> {
        private SearchImageSetsResponseFetcher() {
        }

        public boolean hasNextPage(SearchImageSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchImageSetsResponse nextPage(SearchImageSetsResponse previousPage) {
            if (previousPage == null) {
                return SearchImageSetsIterable.this.client.searchImageSets(SearchImageSetsIterable.this.firstRequest);
            }
            return SearchImageSetsIterable.this.client.searchImageSets((SearchImageSetsRequest)((Object)SearchImageSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

