/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.AccessConfiguration;
import software.amazon.awssdk.services.mediatailor.model.DefaultSegmentDeliveryConfiguration;
import software.amazon.awssdk.services.mediatailor.model.HttpConfiguration;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration;
import software.amazon.awssdk.services.mediatailor.model.___listOfSegmentDeliveryConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSourceLocationRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, UpdateSourceLocationRequest> {
    private static final SdkField<AccessConfiguration> ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessConfiguration").getter(UpdateSourceLocationRequest.getter(UpdateSourceLocationRequest::accessConfiguration)).setter(UpdateSourceLocationRequest.setter(Builder::accessConfiguration)).constructor(AccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessConfiguration").build()}).build();
    private static final SdkField<DefaultSegmentDeliveryConfiguration> DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultSegmentDeliveryConfiguration").getter(UpdateSourceLocationRequest.getter(UpdateSourceLocationRequest::defaultSegmentDeliveryConfiguration)).setter(UpdateSourceLocationRequest.setter(Builder::defaultSegmentDeliveryConfiguration)).constructor(DefaultSegmentDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSegmentDeliveryConfiguration").build()}).build();
    private static final SdkField<HttpConfiguration> HTTP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpConfiguration").getter(UpdateSourceLocationRequest.getter(UpdateSourceLocationRequest::httpConfiguration)).setter(UpdateSourceLocationRequest.setter(Builder::httpConfiguration)).constructor(HttpConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpConfiguration").build()}).build();
    private static final SdkField<List<SegmentDeliveryConfiguration>> SEGMENT_DELIVERY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SegmentDeliveryConfigurations").getter(UpdateSourceLocationRequest.getter(UpdateSourceLocationRequest::segmentDeliveryConfigurations)).setter(UpdateSourceLocationRequest.setter(Builder::segmentDeliveryConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDeliveryConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(UpdateSourceLocationRequest.getter(UpdateSourceLocationRequest::sourceLocationName)).setter(UpdateSourceLocationRequest.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceLocationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONFIGURATION_FIELD, DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD, HTTP_CONFIGURATION_FIELD, SEGMENT_DELIVERY_CONFIGURATIONS_FIELD, SOURCE_LOCATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSourceLocationRequest.memberNameToFieldInitializer();
    private final AccessConfiguration accessConfiguration;
    private final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;
    private final HttpConfiguration httpConfiguration;
    private final List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations;
    private final String sourceLocationName;

    private UpdateSourceLocationRequest(BuilderImpl builder) {
        super(builder);
        this.accessConfiguration = builder.accessConfiguration;
        this.defaultSegmentDeliveryConfiguration = builder.defaultSegmentDeliveryConfiguration;
        this.httpConfiguration = builder.httpConfiguration;
        this.segmentDeliveryConfigurations = builder.segmentDeliveryConfigurations;
        this.sourceLocationName = builder.sourceLocationName;
    }

    public final AccessConfiguration accessConfiguration() {
        return this.accessConfiguration;
    }

    public final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration() {
        return this.defaultSegmentDeliveryConfiguration;
    }

    public final HttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    public final boolean hasSegmentDeliveryConfigurations() {
        return this.segmentDeliveryConfigurations != null && !(this.segmentDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations() {
        return this.segmentDeliveryConfigurations;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSegmentDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentDeliveryConfigurations() ? this.segmentDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceLocationRequest)) {
            return false;
        }
        UpdateSourceLocationRequest other = (UpdateSourceLocationRequest)((Object)obj);
        return Objects.equals(this.accessConfiguration(), other.accessConfiguration()) && Objects.equals(this.defaultSegmentDeliveryConfiguration(), other.defaultSegmentDeliveryConfiguration()) && Objects.equals(this.httpConfiguration(), other.httpConfiguration()) && this.hasSegmentDeliveryConfigurations() == other.hasSegmentDeliveryConfigurations() && Objects.equals(this.segmentDeliveryConfigurations(), other.segmentDeliveryConfigurations()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSourceLocationRequest").add("AccessConfiguration", (Object)this.accessConfiguration()).add("DefaultSegmentDeliveryConfiguration", (Object)this.defaultSegmentDeliveryConfiguration()).add("HttpConfiguration", (Object)this.httpConfiguration()).add("SegmentDeliveryConfigurations", this.hasSegmentDeliveryConfigurations() ? this.segmentDeliveryConfigurations() : null).add("SourceLocationName", (Object)this.sourceLocationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accessConfiguration()));
            }
            case "DefaultSegmentDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultSegmentDeliveryConfiguration()));
            }
            case "HttpConfiguration": {
                return Optional.ofNullable(clazz.cast(this.httpConfiguration()));
            }
            case "SegmentDeliveryConfigurations": {
                return Optional.ofNullable(clazz.cast(this.segmentDeliveryConfigurations()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessConfiguration", ACCESS_CONFIGURATION_FIELD);
        map.put("DefaultSegmentDeliveryConfiguration", DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD);
        map.put("HttpConfiguration", HTTP_CONFIGURATION_FIELD);
        map.put("SegmentDeliveryConfigurations", SEGMENT_DELIVERY_CONFIGURATIONS_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceLocationRequest, T> g) {
        return obj -> g.apply((UpdateSourceLocationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private AccessConfiguration accessConfiguration;
        private DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;
        private HttpConfiguration httpConfiguration;
        private List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String sourceLocationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceLocationRequest model) {
            super(model);
            this.accessConfiguration(model.accessConfiguration);
            this.defaultSegmentDeliveryConfiguration(model.defaultSegmentDeliveryConfiguration);
            this.httpConfiguration(model.httpConfiguration);
            this.segmentDeliveryConfigurations(model.segmentDeliveryConfigurations);
            this.sourceLocationName(model.sourceLocationName);
        }

        public final AccessConfiguration.Builder getAccessConfiguration() {
            return this.accessConfiguration != null ? this.accessConfiguration.toBuilder() : null;
        }

        public final void setAccessConfiguration(AccessConfiguration.BuilderImpl accessConfiguration) {
            this.accessConfiguration = accessConfiguration != null ? accessConfiguration.build() : null;
        }

        @Override
        public final Builder accessConfiguration(AccessConfiguration accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        public final DefaultSegmentDeliveryConfiguration.Builder getDefaultSegmentDeliveryConfiguration() {
            return this.defaultSegmentDeliveryConfiguration != null ? this.defaultSegmentDeliveryConfiguration.toBuilder() : null;
        }

        public final void setDefaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration.BuilderImpl defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration;
            return this;
        }

        public final HttpConfiguration.Builder getHttpConfiguration() {
            return this.httpConfiguration != null ? this.httpConfiguration.toBuilder() : null;
        }

        public final void setHttpConfiguration(HttpConfiguration.BuilderImpl httpConfiguration) {
            this.httpConfiguration = httpConfiguration != null ? httpConfiguration.build() : null;
        }

        @Override
        public final Builder httpConfiguration(HttpConfiguration httpConfiguration) {
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        public final List<SegmentDeliveryConfiguration.Builder> getSegmentDeliveryConfigurations() {
            List<SegmentDeliveryConfiguration.Builder> result = ___listOfSegmentDeliveryConfigurationCopier.copyToBuilder(this.segmentDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentDeliveryConfigurations(Collection<SegmentDeliveryConfiguration.BuilderImpl> segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = ___listOfSegmentDeliveryConfigurationCopier.copyFromBuilder(segmentDeliveryConfigurations);
        }

        @Override
        public final Builder segmentDeliveryConfigurations(Collection<SegmentDeliveryConfiguration> segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = ___listOfSegmentDeliveryConfigurationCopier.copy(segmentDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentDeliveryConfigurations(SegmentDeliveryConfiguration ... segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations(Arrays.asList(segmentDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentDeliveryConfigurations(Consumer<SegmentDeliveryConfiguration.Builder> ... segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations(Stream.of(segmentDeliveryConfigurations).map(c -> (SegmentDeliveryConfiguration)((SegmentDeliveryConfiguration.Builder)SegmentDeliveryConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSourceLocationRequest build() {
            return new UpdateSourceLocationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSourceLocationRequest> {
        public Builder accessConfiguration(AccessConfiguration var1);

        default public Builder accessConfiguration(Consumer<AccessConfiguration.Builder> accessConfiguration) {
            return this.accessConfiguration((AccessConfiguration)((AccessConfiguration.Builder)AccessConfiguration.builder().applyMutation(accessConfiguration)).build());
        }

        public Builder defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration var1);

        default public Builder defaultSegmentDeliveryConfiguration(Consumer<DefaultSegmentDeliveryConfiguration.Builder> defaultSegmentDeliveryConfiguration) {
            return this.defaultSegmentDeliveryConfiguration((DefaultSegmentDeliveryConfiguration)((DefaultSegmentDeliveryConfiguration.Builder)DefaultSegmentDeliveryConfiguration.builder().applyMutation(defaultSegmentDeliveryConfiguration)).build());
        }

        public Builder httpConfiguration(HttpConfiguration var1);

        default public Builder httpConfiguration(Consumer<HttpConfiguration.Builder> httpConfiguration) {
            return this.httpConfiguration((HttpConfiguration)((HttpConfiguration.Builder)HttpConfiguration.builder().applyMutation(httpConfiguration)).build());
        }

        public Builder segmentDeliveryConfigurations(Collection<SegmentDeliveryConfiguration> var1);

        public Builder segmentDeliveryConfigurations(SegmentDeliveryConfiguration ... var1);

        public Builder segmentDeliveryConfigurations(Consumer<SegmentDeliveryConfiguration.Builder> ... var1);

        public Builder sourceLocationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

