/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.AdsInteractionLog;
import software.amazon.awssdk.services.mediatailor.model.LoggingStrategy;
import software.amazon.awssdk.services.mediatailor.model.ManifestServiceInteractionLog;
import software.amazon.awssdk.services.mediatailor.model.___listOfLoggingStrategiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfiguration> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentEnabled").getter(LogConfiguration.getter(LogConfiguration::percentEnabled)).setter(LogConfiguration.setter(Builder::percentEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()}).build();
    private static final SdkField<List<String>> ENABLED_LOGGING_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledLoggingStrategies").getter(LogConfiguration.getter(LogConfiguration::enabledLoggingStrategiesAsStrings)).setter(LogConfiguration.setter(Builder::enabledLoggingStrategiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledLoggingStrategies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AdsInteractionLog> ADS_INTERACTION_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdsInteractionLog").getter(LogConfiguration.getter(LogConfiguration::adsInteractionLog)).setter(LogConfiguration.setter(Builder::adsInteractionLog)).constructor(AdsInteractionLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdsInteractionLog").build()}).build();
    private static final SdkField<ManifestServiceInteractionLog> MANIFEST_SERVICE_INTERACTION_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestServiceInteractionLog").getter(LogConfiguration.getter(LogConfiguration::manifestServiceInteractionLog)).setter(LogConfiguration.setter(Builder::manifestServiceInteractionLog)).constructor(ManifestServiceInteractionLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestServiceInteractionLog").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD, ENABLED_LOGGING_STRATEGIES_FIELD, ADS_INTERACTION_LOG_FIELD, MANIFEST_SERVICE_INTERACTION_LOG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer percentEnabled;
    private final List<String> enabledLoggingStrategies;
    private final AdsInteractionLog adsInteractionLog;
    private final ManifestServiceInteractionLog manifestServiceInteractionLog;

    private LogConfiguration(BuilderImpl builder) {
        this.percentEnabled = builder.percentEnabled;
        this.enabledLoggingStrategies = builder.enabledLoggingStrategies;
        this.adsInteractionLog = builder.adsInteractionLog;
        this.manifestServiceInteractionLog = builder.manifestServiceInteractionLog;
    }

    public final Integer percentEnabled() {
        return this.percentEnabled;
    }

    public final List<LoggingStrategy> enabledLoggingStrategies() {
        return ___listOfLoggingStrategiesCopier.copyStringToEnum(this.enabledLoggingStrategies);
    }

    public final boolean hasEnabledLoggingStrategies() {
        return this.enabledLoggingStrategies != null && !(this.enabledLoggingStrategies instanceof SdkAutoConstructList);
    }

    public final List<String> enabledLoggingStrategiesAsStrings() {
        return this.enabledLoggingStrategies;
    }

    public final AdsInteractionLog adsInteractionLog() {
        return this.adsInteractionLog;
    }

    public final ManifestServiceInteractionLog manifestServiceInteractionLog() {
        return this.manifestServiceInteractionLog;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledLoggingStrategies() ? this.enabledLoggingStrategiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.adsInteractionLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestServiceInteractionLog());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        return Objects.equals(this.percentEnabled(), other.percentEnabled()) && this.hasEnabledLoggingStrategies() == other.hasEnabledLoggingStrategies() && Objects.equals(this.enabledLoggingStrategiesAsStrings(), other.enabledLoggingStrategiesAsStrings()) && Objects.equals(this.adsInteractionLog(), other.adsInteractionLog()) && Objects.equals(this.manifestServiceInteractionLog(), other.manifestServiceInteractionLog());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfiguration").add("PercentEnabled", (Object)this.percentEnabled()).add("EnabledLoggingStrategies", this.hasEnabledLoggingStrategies() ? this.enabledLoggingStrategiesAsStrings() : null).add("AdsInteractionLog", (Object)this.adsInteractionLog()).add("ManifestServiceInteractionLog", (Object)this.manifestServiceInteractionLog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PercentEnabled": {
                return Optional.ofNullable(clazz.cast(this.percentEnabled()));
            }
            case "EnabledLoggingStrategies": {
                return Optional.ofNullable(clazz.cast(this.enabledLoggingStrategiesAsStrings()));
            }
            case "AdsInteractionLog": {
                return Optional.ofNullable(clazz.cast(this.adsInteractionLog()));
            }
            case "ManifestServiceInteractionLog": {
                return Optional.ofNullable(clazz.cast(this.manifestServiceInteractionLog()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PercentEnabled", PERCENT_ENABLED_FIELD);
        map.put("EnabledLoggingStrategies", ENABLED_LOGGING_STRATEGIES_FIELD);
        map.put("AdsInteractionLog", ADS_INTERACTION_LOG_FIELD);
        map.put("ManifestServiceInteractionLog", MANIFEST_SERVICE_INTERACTION_LOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer percentEnabled;
        private List<String> enabledLoggingStrategies = DefaultSdkAutoConstructList.getInstance();
        private AdsInteractionLog adsInteractionLog;
        private ManifestServiceInteractionLog manifestServiceInteractionLog;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            this.percentEnabled(model.percentEnabled);
            this.enabledLoggingStrategiesWithStrings(model.enabledLoggingStrategies);
            this.adsInteractionLog(model.adsInteractionLog);
            this.manifestServiceInteractionLog(model.manifestServiceInteractionLog);
        }

        public final Integer getPercentEnabled() {
            return this.percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final Collection<String> getEnabledLoggingStrategies() {
            if (this.enabledLoggingStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledLoggingStrategies;
        }

        public final void setEnabledLoggingStrategies(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
        }

        @Override
        public final Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategiesWithStrings(String ... enabledLoggingStrategies) {
            this.enabledLoggingStrategiesWithStrings(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public final Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copyEnumToString(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategies(LoggingStrategy ... enabledLoggingStrategies) {
            this.enabledLoggingStrategies(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        public final AdsInteractionLog.Builder getAdsInteractionLog() {
            return this.adsInteractionLog != null ? this.adsInteractionLog.toBuilder() : null;
        }

        public final void setAdsInteractionLog(AdsInteractionLog.BuilderImpl adsInteractionLog) {
            this.adsInteractionLog = adsInteractionLog != null ? adsInteractionLog.build() : null;
        }

        @Override
        public final Builder adsInteractionLog(AdsInteractionLog adsInteractionLog) {
            this.adsInteractionLog = adsInteractionLog;
            return this;
        }

        public final ManifestServiceInteractionLog.Builder getManifestServiceInteractionLog() {
            return this.manifestServiceInteractionLog != null ? this.manifestServiceInteractionLog.toBuilder() : null;
        }

        public final void setManifestServiceInteractionLog(ManifestServiceInteractionLog.BuilderImpl manifestServiceInteractionLog) {
            this.manifestServiceInteractionLog = manifestServiceInteractionLog != null ? manifestServiceInteractionLog.build() : null;
        }

        @Override
        public final Builder manifestServiceInteractionLog(ManifestServiceInteractionLog manifestServiceInteractionLog) {
            this.manifestServiceInteractionLog = manifestServiceInteractionLog;
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfiguration> {
        public Builder percentEnabled(Integer var1);

        public Builder enabledLoggingStrategiesWithStrings(Collection<String> var1);

        public Builder enabledLoggingStrategiesWithStrings(String ... var1);

        public Builder enabledLoggingStrategies(Collection<LoggingStrategy> var1);

        public Builder enabledLoggingStrategies(LoggingStrategy ... var1);

        public Builder adsInteractionLog(AdsInteractionLog var1);

        default public Builder adsInteractionLog(Consumer<AdsInteractionLog.Builder> adsInteractionLog) {
            return this.adsInteractionLog((AdsInteractionLog)((AdsInteractionLog.Builder)AdsInteractionLog.builder().applyMutation(adsInteractionLog)).build());
        }

        public Builder manifestServiceInteractionLog(ManifestServiceInteractionLog var1);

        default public Builder manifestServiceInteractionLog(Consumer<ManifestServiceInteractionLog.Builder> manifestServiceInteractionLog) {
            return this.manifestServiceInteractionLog((ManifestServiceInteractionLog)((ManifestServiceInteractionLog.Builder)ManifestServiceInteractionLog.builder().applyMutation(manifestServiceInteractionLog)).build());
        }
    }
}

