/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLiveSourceRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, DeleteLiveSourceRequest> {
    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LiveSourceName").getter(DeleteLiveSourceRequest.getter(DeleteLiveSourceRequest::liveSourceName)).setter(DeleteLiveSourceRequest.setter(Builder::liveSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LiveSourceName").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(DeleteLiveSourceRequest.getter(DeleteLiveSourceRequest::sourceLocationName)).setter(DeleteLiveSourceRequest.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceLocationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIVE_SOURCE_NAME_FIELD, SOURCE_LOCATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteLiveSourceRequest.memberNameToFieldInitializer();
    private final String liveSourceName;
    private final String sourceLocationName;

    private DeleteLiveSourceRequest(BuilderImpl builder) {
        super(builder);
        this.liveSourceName = builder.liveSourceName;
        this.sourceLocationName = builder.sourceLocationName;
    }

    public final String liveSourceName() {
        return this.liveSourceName;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLiveSourceRequest)) {
            return false;
        }
        DeleteLiveSourceRequest other = (DeleteLiveSourceRequest)((Object)obj);
        return Objects.equals(this.liveSourceName(), other.liveSourceName()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLiveSourceRequest").add("LiveSourceName", (Object)this.liveSourceName()).add("SourceLocationName", (Object)this.sourceLocationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LiveSourceName": {
                return Optional.ofNullable(clazz.cast(this.liveSourceName()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LiveSourceName", LIVE_SOURCE_NAME_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLiveSourceRequest, T> g) {
        return obj -> g.apply((DeleteLiveSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private String liveSourceName;
        private String sourceLocationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLiveSourceRequest model) {
            super(model);
            this.liveSourceName(model.liveSourceName);
            this.sourceLocationName(model.sourceLocationName);
        }

        public final String getLiveSourceName() {
            return this.liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLiveSourceRequest build() {
            return new DeleteLiveSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLiveSourceRequest> {
        public Builder liveSourceName(String var1);

        public Builder sourceLocationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

