/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.RecurringConsumption;
import software.amazon.awssdk.services.mediatailor.model.RecurringRetrieval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecurringPrefetchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecurringPrefetchConfiguration> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(RecurringPrefetchConfiguration.getter(RecurringPrefetchConfiguration::startTime)).setter(RecurringPrefetchConfiguration.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(RecurringPrefetchConfiguration.getter(RecurringPrefetchConfiguration::endTime)).setter(RecurringPrefetchConfiguration.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<RecurringConsumption> RECURRING_CONSUMPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecurringConsumption").getter(RecurringPrefetchConfiguration.getter(RecurringPrefetchConfiguration::recurringConsumption)).setter(RecurringPrefetchConfiguration.setter(Builder::recurringConsumption)).constructor(RecurringConsumption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringConsumption").build()}).build();
    private static final SdkField<RecurringRetrieval> RECURRING_RETRIEVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecurringRetrieval").getter(RecurringPrefetchConfiguration.getter(RecurringPrefetchConfiguration::recurringRetrieval)).setter(RecurringPrefetchConfiguration.setter(Builder::recurringRetrieval)).constructor(RecurringRetrieval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringRetrieval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, RECURRING_CONSUMPTION_FIELD, RECURRING_RETRIEVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecurringPrefetchConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant startTime;
    private final Instant endTime;
    private final RecurringConsumption recurringConsumption;
    private final RecurringRetrieval recurringRetrieval;

    private RecurringPrefetchConfiguration(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recurringConsumption = builder.recurringConsumption;
        this.recurringRetrieval = builder.recurringRetrieval;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final RecurringConsumption recurringConsumption() {
        return this.recurringConsumption;
    }

    public final RecurringRetrieval recurringRetrieval() {
        return this.recurringRetrieval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringConsumption());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringRetrieval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringPrefetchConfiguration)) {
            return false;
        }
        RecurringPrefetchConfiguration other = (RecurringPrefetchConfiguration)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.recurringConsumption(), other.recurringConsumption()) && Objects.equals(this.recurringRetrieval(), other.recurringRetrieval());
    }

    public final String toString() {
        return ToString.builder((String)"RecurringPrefetchConfiguration").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("RecurringConsumption", (Object)this.recurringConsumption()).add("RecurringRetrieval", (Object)this.recurringRetrieval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "RecurringConsumption": {
                return Optional.ofNullable(clazz.cast(this.recurringConsumption()));
            }
            case "RecurringRetrieval": {
                return Optional.ofNullable(clazz.cast(this.recurringRetrieval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("RecurringConsumption", RECURRING_CONSUMPTION_FIELD);
        map.put("RecurringRetrieval", RECURRING_RETRIEVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecurringPrefetchConfiguration, T> g) {
        return obj -> g.apply((RecurringPrefetchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private RecurringConsumption recurringConsumption;
        private RecurringRetrieval recurringRetrieval;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringPrefetchConfiguration model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.recurringConsumption(model.recurringConsumption);
            this.recurringRetrieval(model.recurringRetrieval);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final RecurringConsumption.Builder getRecurringConsumption() {
            return this.recurringConsumption != null ? this.recurringConsumption.toBuilder() : null;
        }

        public final void setRecurringConsumption(RecurringConsumption.BuilderImpl recurringConsumption) {
            this.recurringConsumption = recurringConsumption != null ? recurringConsumption.build() : null;
        }

        @Override
        public final Builder recurringConsumption(RecurringConsumption recurringConsumption) {
            this.recurringConsumption = recurringConsumption;
            return this;
        }

        public final RecurringRetrieval.Builder getRecurringRetrieval() {
            return this.recurringRetrieval != null ? this.recurringRetrieval.toBuilder() : null;
        }

        public final void setRecurringRetrieval(RecurringRetrieval.BuilderImpl recurringRetrieval) {
            this.recurringRetrieval = recurringRetrieval != null ? recurringRetrieval.build() : null;
        }

        @Override
        public final Builder recurringRetrieval(RecurringRetrieval recurringRetrieval) {
            this.recurringRetrieval = recurringRetrieval;
            return this;
        }

        public RecurringPrefetchConfiguration build() {
            return new RecurringPrefetchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecurringPrefetchConfiguration> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder recurringConsumption(RecurringConsumption var1);

        default public Builder recurringConsumption(Consumer<RecurringConsumption.Builder> recurringConsumption) {
            return this.recurringConsumption((RecurringConsumption)((RecurringConsumption.Builder)RecurringConsumption.builder().applyMutation(recurringConsumption)).build());
        }

        public Builder recurringRetrieval(RecurringRetrieval var1);

        default public Builder recurringRetrieval(Consumer<RecurringRetrieval.Builder> recurringRetrieval) {
            return this.recurringRetrieval((RecurringRetrieval)((RecurringRetrieval.Builder)RecurringRetrieval.builder().applyMutation(recurringRetrieval)).build());
        }
    }
}

