/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.mediastoredata.auth.scheme.MediaStoreDataAuthSchemeParams;
import software.amazon.awssdk.services.mediastoredata.auth.scheme.internal.DefaultMediaStoreDataAuthSchemeProvider;
import software.amazon.awssdk.services.mediastoredata.auth.scheme.internal.PreferredMediaStoreDataAuthSchemeProvider;

@SdkPublicApi
public interface MediaStoreDataAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(MediaStoreDataAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<MediaStoreDataAuthSchemeParams.Builder> consumer) {
        MediaStoreDataAuthSchemeParams.Builder builder = MediaStoreDataAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static MediaStoreDataAuthSchemeProvider defaultProvider() {
        return DefaultMediaStoreDataAuthSchemeProvider.create();
    }

    public static MediaStoreDataAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredMediaStoreDataAuthSchemeProvider(MediaStoreDataAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

