/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediastore.MediaStoreAsyncClient;
import software.amazon.awssdk.services.mediastore.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediastore.model.ListContainersRequest;
import software.amazon.awssdk.services.mediastore.model.ListContainersResponse;

public class ListContainersPublisher
implements SdkPublisher<ListContainersResponse> {
    private final MediaStoreAsyncClient client;
    private final ListContainersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContainersPublisher(MediaStoreAsyncClient client, ListContainersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContainersPublisher(MediaStoreAsyncClient client, ListContainersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContainersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContainersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListContainersResponseFetcher
    implements AsyncPageFetcher<ListContainersResponse> {
        private ListContainersResponseFetcher() {
        }

        public boolean hasNextPage(ListContainersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContainersResponse> nextPage(ListContainersResponse previousPage) {
            if (previousPage == null) {
                return ListContainersPublisher.this.client.listContainers(ListContainersPublisher.this.firstRequest);
            }
            return ListContainersPublisher.this.client.listContainers((ListContainersRequest)((Object)ListContainersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

