/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.mediapackagev2.auth.scheme.MediaPackageV2AuthSchemeParams;
import software.amazon.awssdk.services.mediapackagev2.auth.scheme.internal.DefaultMediaPackageV2AuthSchemeProvider;
import software.amazon.awssdk.services.mediapackagev2.auth.scheme.internal.PreferredMediaPackageV2AuthSchemeProvider;

@SdkPublicApi
public interface MediaPackageV2AuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(MediaPackageV2AuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<MediaPackageV2AuthSchemeParams.Builder> consumer) {
        MediaPackageV2AuthSchemeParams.Builder builder = MediaPackageV2AuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static MediaPackageV2AuthSchemeProvider defaultProvider() {
        return DefaultMediaPackageV2AuthSchemeProvider.create();
    }

    public static MediaPackageV2AuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredMediaPackageV2AuthSchemeProvider(MediaPackageV2AuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

