/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.ScteFilter;
import software.amazon.awssdk.services.mediapackagev2.model.ScteFilterListCopier;
import software.amazon.awssdk.services.mediapackagev2.model.ScteInSegments;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scte
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Scte> {
    private static final SdkField<List<String>> SCTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScteFilter").getter(Scte.getter(Scte::scteFilterAsStrings)).setter(Scte.setter(Builder::scteFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCTE_IN_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScteInSegments").getter(Scte.getter(Scte::scteInSegmentsAsString)).setter(Scte.setter(Builder::scteInSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteInSegments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCTE_FILTER_FIELD, SCTE_IN_SEGMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Scte.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> scteFilter;
    private final String scteInSegments;

    private Scte(BuilderImpl builder) {
        this.scteFilter = builder.scteFilter;
        this.scteInSegments = builder.scteInSegments;
    }

    public final List<ScteFilter> scteFilter() {
        return ScteFilterListCopier.copyStringToEnum(this.scteFilter);
    }

    public final boolean hasScteFilter() {
        return this.scteFilter != null && !(this.scteFilter instanceof SdkAutoConstructList);
    }

    public final List<String> scteFilterAsStrings() {
        return this.scteFilter;
    }

    public final ScteInSegments scteInSegments() {
        return ScteInSegments.fromValue(this.scteInSegments);
    }

    public final String scteInSegmentsAsString() {
        return this.scteInSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScteFilter() ? this.scteFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scteInSegmentsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte)) {
            return false;
        }
        Scte other = (Scte)obj;
        return this.hasScteFilter() == other.hasScteFilter() && Objects.equals(this.scteFilterAsStrings(), other.scteFilterAsStrings()) && Objects.equals(this.scteInSegmentsAsString(), other.scteInSegmentsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Scte").add("ScteFilter", this.hasScteFilter() ? this.scteFilterAsStrings() : null).add("ScteInSegments", (Object)this.scteInSegmentsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScteFilter": {
                return Optional.ofNullable(clazz.cast(this.scteFilterAsStrings()));
            }
            case "ScteInSegments": {
                return Optional.ofNullable(clazz.cast(this.scteInSegmentsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScteFilter", SCTE_FILTER_FIELD);
        map.put("ScteInSegments", SCTE_IN_SEGMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Scte, T> g) {
        return obj -> g.apply((Scte)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> scteFilter = DefaultSdkAutoConstructList.getInstance();
        private String scteInSegments;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte model) {
            this.scteFilterWithStrings(model.scteFilter);
            this.scteInSegments(model.scteInSegments);
        }

        public final Collection<String> getScteFilter() {
            if (this.scteFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scteFilter;
        }

        public final void setScteFilter(Collection<String> scteFilter) {
            this.scteFilter = ScteFilterListCopier.copy(scteFilter);
        }

        @Override
        public final Builder scteFilterWithStrings(Collection<String> scteFilter) {
            this.scteFilter = ScteFilterListCopier.copy(scteFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scteFilterWithStrings(String ... scteFilter) {
            this.scteFilterWithStrings(Arrays.asList(scteFilter));
            return this;
        }

        @Override
        public final Builder scteFilter(Collection<ScteFilter> scteFilter) {
            this.scteFilter = ScteFilterListCopier.copyEnumToString(scteFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scteFilter(ScteFilter ... scteFilter) {
            this.scteFilter(Arrays.asList(scteFilter));
            return this;
        }

        public final String getScteInSegments() {
            return this.scteInSegments;
        }

        public final void setScteInSegments(String scteInSegments) {
            this.scteInSegments = scteInSegments;
        }

        @Override
        public final Builder scteInSegments(String scteInSegments) {
            this.scteInSegments = scteInSegments;
            return this;
        }

        @Override
        public final Builder scteInSegments(ScteInSegments scteInSegments) {
            this.scteInSegments(scteInSegments == null ? null : scteInSegments.toString());
            return this;
        }

        public Scte build() {
            return new Scte(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Scte> {
        public Builder scteFilterWithStrings(Collection<String> var1);

        public Builder scteFilterWithStrings(String ... var1);

        public Builder scteFilter(Collection<ScteFilter> var1);

        public Builder scteFilter(ScteFilter ... var1);

        public Builder scteInSegments(String var1);

        public Builder scteInSegments(ScteInSegments var1);
    }
}

