/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterConfiguration> {
    private static final SdkField<String> MANIFEST_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestFilter").getter(FilterConfiguration.getter(FilterConfiguration::manifestFilter)).setter(FilterConfiguration.setter(Builder::manifestFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFilter").build()}).build();
    private static final SdkField<String> DRM_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrmSettings").getter(FilterConfiguration.getter(FilterConfiguration::drmSettings)).setter(FilterConfiguration.setter(Builder::drmSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrmSettings").build()}).build();
    private static final SdkField<Instant> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Start").getter(FilterConfiguration.getter(FilterConfiguration::start)).setter(FilterConfiguration.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()}).build();
    private static final SdkField<Instant> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("End").getter(FilterConfiguration.getter(FilterConfiguration::end)).setter(FilterConfiguration.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()}).build();
    private static final SdkField<Integer> TIME_DELAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeDelaySeconds").getter(FilterConfiguration.getter(FilterConfiguration::timeDelaySeconds)).setter(FilterConfiguration.setter(Builder::timeDelaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeDelaySeconds").build()}).build();
    private static final SdkField<Instant> CLIP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ClipStartTime").getter(FilterConfiguration.getter(FilterConfiguration::clipStartTime)).setter(FilterConfiguration.setter(Builder::clipStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClipStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_FILTER_FIELD, DRM_SETTINGS_FIELD, START_FIELD, END_FIELD, TIME_DELAY_SECONDS_FIELD, CLIP_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String manifestFilter;
    private final String drmSettings;
    private final Instant start;
    private final Instant end;
    private final Integer timeDelaySeconds;
    private final Instant clipStartTime;

    private FilterConfiguration(BuilderImpl builder) {
        this.manifestFilter = builder.manifestFilter;
        this.drmSettings = builder.drmSettings;
        this.start = builder.start;
        this.end = builder.end;
        this.timeDelaySeconds = builder.timeDelaySeconds;
        this.clipStartTime = builder.clipStartTime;
    }

    public final String manifestFilter() {
        return this.manifestFilter;
    }

    public final String drmSettings() {
        return this.drmSettings;
    }

    public final Instant start() {
        return this.start;
    }

    public final Instant end() {
        return this.end;
    }

    public final Integer timeDelaySeconds() {
        return this.timeDelaySeconds;
    }

    public final Instant clipStartTime() {
        return this.clipStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.drmSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.clipStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterConfiguration)) {
            return false;
        }
        FilterConfiguration other = (FilterConfiguration)obj;
        return Objects.equals(this.manifestFilter(), other.manifestFilter()) && Objects.equals(this.drmSettings(), other.drmSettings()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.timeDelaySeconds(), other.timeDelaySeconds()) && Objects.equals(this.clipStartTime(), other.clipStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"FilterConfiguration").add("ManifestFilter", (Object)this.manifestFilter()).add("DrmSettings", (Object)this.drmSettings()).add("Start", (Object)this.start()).add("End", (Object)this.end()).add("TimeDelaySeconds", (Object)this.timeDelaySeconds()).add("ClipStartTime", (Object)this.clipStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestFilter": {
                return Optional.ofNullable(clazz.cast(this.manifestFilter()));
            }
            case "DrmSettings": {
                return Optional.ofNullable(clazz.cast(this.drmSettings()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "TimeDelaySeconds": {
                return Optional.ofNullable(clazz.cast(this.timeDelaySeconds()));
            }
            case "ClipStartTime": {
                return Optional.ofNullable(clazz.cast(this.clipStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManifestFilter", MANIFEST_FILTER_FIELD);
        map.put("DrmSettings", DRM_SETTINGS_FIELD);
        map.put("Start", START_FIELD);
        map.put("End", END_FIELD);
        map.put("TimeDelaySeconds", TIME_DELAY_SECONDS_FIELD);
        map.put("ClipStartTime", CLIP_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterConfiguration, T> g) {
        return obj -> g.apply((FilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestFilter;
        private String drmSettings;
        private Instant start;
        private Instant end;
        private Integer timeDelaySeconds;
        private Instant clipStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterConfiguration model) {
            this.manifestFilter(model.manifestFilter);
            this.drmSettings(model.drmSettings);
            this.start(model.start);
            this.end(model.end);
            this.timeDelaySeconds(model.timeDelaySeconds);
            this.clipStartTime(model.clipStartTime);
        }

        public final String getManifestFilter() {
            return this.manifestFilter;
        }

        public final void setManifestFilter(String manifestFilter) {
            this.manifestFilter = manifestFilter;
        }

        @Override
        public final Builder manifestFilter(String manifestFilter) {
            this.manifestFilter = manifestFilter;
            return this;
        }

        public final String getDrmSettings() {
            return this.drmSettings;
        }

        public final void setDrmSettings(String drmSettings) {
            this.drmSettings = drmSettings;
        }

        @Override
        public final Builder drmSettings(String drmSettings) {
            this.drmSettings = drmSettings;
            return this;
        }

        public final Instant getStart() {
            return this.start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return this.end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final Integer getTimeDelaySeconds() {
            return this.timeDelaySeconds;
        }

        public final void setTimeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
        }

        @Override
        public final Builder timeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
            return this;
        }

        public final Instant getClipStartTime() {
            return this.clipStartTime;
        }

        public final void setClipStartTime(Instant clipStartTime) {
            this.clipStartTime = clipStartTime;
        }

        @Override
        public final Builder clipStartTime(Instant clipStartTime) {
            this.clipStartTime = clipStartTime;
            return this;
        }

        public FilterConfiguration build() {
            return new FilterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterConfiguration> {
        public Builder manifestFilter(String var1);

        public Builder drmSettings(String var1);

        public Builder start(Instant var1);

        public Builder end(Instant var1);

        public Builder timeDelaySeconds(Integer var1);

        public Builder clipStartTime(Instant var1);
    }
}

