/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetOriginEndpointStateResponse
extends MediaPackageV2Response
implements ToCopyableBuilder<Builder, ResetOriginEndpointStateResponse> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(ResetOriginEndpointStateResponse.getter(ResetOriginEndpointStateResponse::channelGroupName)).setter(ResetOriginEndpointStateResponse.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(ResetOriginEndpointStateResponse.getter(ResetOriginEndpointStateResponse::channelName)).setter(ResetOriginEndpointStateResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointName").getter(ResetOriginEndpointStateResponse.getter(ResetOriginEndpointStateResponse::originEndpointName)).setter(ResetOriginEndpointStateResponse.setter(Builder::originEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ResetOriginEndpointStateResponse.getter(ResetOriginEndpointStateResponse::arn)).setter(ResetOriginEndpointStateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> RESET_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResetAt").getter(ResetOriginEndpointStateResponse.getter(ResetOriginEndpointStateResponse::resetAt)).setter(ResetOriginEndpointStateResponse.setter(Builder::resetAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, ARN_FIELD, RESET_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResetOriginEndpointStateResponse.memberNameToFieldInitializer();
    private final String channelGroupName;
    private final String channelName;
    private final String originEndpointName;
    private final String arn;
    private final Instant resetAt;

    private ResetOriginEndpointStateResponse(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.arn = builder.arn;
        this.resetAt = builder.resetAt;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String originEndpointName() {
        return this.originEndpointName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant resetAt() {
        return this.resetAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetOriginEndpointStateResponse)) {
            return false;
        }
        ResetOriginEndpointStateResponse other = (ResetOriginEndpointStateResponse)((Object)obj);
        return Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.originEndpointName(), other.originEndpointName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resetAt(), other.resetAt());
    }

    public final String toString() {
        return ToString.builder((String)"ResetOriginEndpointStateResponse").add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("OriginEndpointName", (Object)this.originEndpointName()).add("Arn", (Object)this.arn()).add("ResetAt", (Object)this.resetAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "OriginEndpointName": {
                return Optional.ofNullable(clazz.cast(this.originEndpointName()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ResetAt": {
                return Optional.ofNullable(clazz.cast(this.resetAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ResetAt", RESET_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetOriginEndpointStateResponse, T> g) {
        return obj -> g.apply((ResetOriginEndpointStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Response.BuilderImpl
    implements Builder {
        private String channelGroupName;
        private String channelName;
        private String originEndpointName;
        private String arn;
        private Instant resetAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetOriginEndpointStateResponse model) {
            super(model);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.originEndpointName(model.originEndpointName);
            this.arn(model.arn);
            this.resetAt(model.resetAt);
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return this.originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getResetAt() {
            return this.resetAt;
        }

        public final void setResetAt(Instant resetAt) {
            this.resetAt = resetAt;
        }

        @Override
        public final Builder resetAt(Instant resetAt) {
            this.resetAt = resetAt;
            return this;
        }

        @Override
        public ResetOriginEndpointStateResponse build() {
            return new ResetOriginEndpointStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaPackageV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetOriginEndpointStateResponse> {
        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder originEndpointName(String var1);

        public Builder arn(String var1);

        public Builder resetAt(Instant var1);
    }
}

