/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedDashManifest;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedDashManifestsListCopier;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedHlsManifest;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedHlsManifestsListCopier;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedLowLatencyHlsManifest;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestedLowLatencyHlsManifestsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HarvestedManifests
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HarvestedManifests> {
    private static final SdkField<List<HarvestedHlsManifest>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HlsManifests").getter(HarvestedManifests.getter(HarvestedManifests::hlsManifests)).setter(HarvestedManifests.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HarvestedHlsManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HarvestedDashManifest>> DASH_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashManifests").getter(HarvestedManifests.getter(HarvestedManifests::dashManifests)).setter(HarvestedManifests.setter(Builder::dashManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HarvestedDashManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HarvestedLowLatencyHlsManifest>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LowLatencyHlsManifests").getter(HarvestedManifests.getter(HarvestedManifests::lowLatencyHlsManifests)).setter(HarvestedManifests.setter(Builder::lowLatencyHlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HarvestedLowLatencyHlsManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_MANIFESTS_FIELD, DASH_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HarvestedManifests.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<HarvestedHlsManifest> hlsManifests;
    private final List<HarvestedDashManifest> dashManifests;
    private final List<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests;

    private HarvestedManifests(BuilderImpl builder) {
        this.hlsManifests = builder.hlsManifests;
        this.dashManifests = builder.dashManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
    }

    public final boolean hasHlsManifests() {
        return this.hlsManifests != null && !(this.hlsManifests instanceof SdkAutoConstructList);
    }

    public final List<HarvestedHlsManifest> hlsManifests() {
        return this.hlsManifests;
    }

    public final boolean hasDashManifests() {
        return this.dashManifests != null && !(this.dashManifests instanceof SdkAutoConstructList);
    }

    public final List<HarvestedDashManifest> dashManifests() {
        return this.dashManifests;
    }

    public final boolean hasLowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests != null && !(this.lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    public final List<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHlsManifests() ? this.hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashManifests() ? this.dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HarvestedManifests)) {
            return false;
        }
        HarvestedManifests other = (HarvestedManifests)obj;
        return this.hasHlsManifests() == other.hasHlsManifests() && Objects.equals(this.hlsManifests(), other.hlsManifests()) && this.hasDashManifests() == other.hasDashManifests() && Objects.equals(this.dashManifests(), other.dashManifests()) && this.hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests() && Objects.equals(this.lowLatencyHlsManifests(), other.lowLatencyHlsManifests());
    }

    public final String toString() {
        return ToString.builder((String)"HarvestedManifests").add("HlsManifests", this.hasHlsManifests() ? this.hlsManifests() : null).add("DashManifests", this.hasDashManifests() ? this.dashManifests() : null).add("LowLatencyHlsManifests", this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "DashManifests": {
                return Optional.ofNullable(clazz.cast(this.dashManifests()));
            }
            case "LowLatencyHlsManifests": {
                return Optional.ofNullable(clazz.cast(this.lowLatencyHlsManifests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HlsManifests", HLS_MANIFESTS_FIELD);
        map.put("DashManifests", DASH_MANIFESTS_FIELD);
        map.put("LowLatencyHlsManifests", LOW_LATENCY_HLS_MANIFESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HarvestedManifests, T> g) {
        return obj -> g.apply((HarvestedManifests)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<HarvestedHlsManifest> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private List<HarvestedDashManifest> dashManifests = DefaultSdkAutoConstructList.getInstance();
        private List<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HarvestedManifests model) {
            this.hlsManifests(model.hlsManifests);
            this.dashManifests(model.dashManifests);
            this.lowLatencyHlsManifests(model.lowLatencyHlsManifests);
        }

        public final List<HarvestedHlsManifest.Builder> getHlsManifests() {
            List<HarvestedHlsManifest.Builder> result = HarvestedHlsManifestsListCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<HarvestedHlsManifest.BuilderImpl> hlsManifests) {
            this.hlsManifests = HarvestedHlsManifestsListCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<HarvestedHlsManifest> hlsManifests) {
            this.hlsManifests = HarvestedHlsManifestsListCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HarvestedHlsManifest ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HarvestedHlsManifest.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (HarvestedHlsManifest)((HarvestedHlsManifest.Builder)HarvestedHlsManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HarvestedDashManifest.Builder> getDashManifests() {
            List<HarvestedDashManifest.Builder> result = HarvestedDashManifestsListCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashManifests(Collection<HarvestedDashManifest.BuilderImpl> dashManifests) {
            this.dashManifests = HarvestedDashManifestsListCopier.copyFromBuilder(dashManifests);
        }

        @Override
        public final Builder dashManifests(Collection<HarvestedDashManifest> dashManifests) {
            this.dashManifests = HarvestedDashManifestsListCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(HarvestedDashManifest ... dashManifests) {
            this.dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<HarvestedDashManifest.Builder> ... dashManifests) {
            this.dashManifests(Stream.of(dashManifests).map(c -> (HarvestedDashManifest)((HarvestedDashManifest.Builder)HarvestedDashManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HarvestedLowLatencyHlsManifest.Builder> getLowLatencyHlsManifests() {
            List<HarvestedLowLatencyHlsManifest.Builder> result = HarvestedLowLatencyHlsManifestsListCopier.copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(Collection<HarvestedLowLatencyHlsManifest.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = HarvestedLowLatencyHlsManifestsListCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = HarvestedLowLatencyHlsManifestsListCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(HarvestedLowLatencyHlsManifest ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(Consumer<HarvestedLowLatencyHlsManifest.Builder> ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests).map(c -> (HarvestedLowLatencyHlsManifest)((HarvestedLowLatencyHlsManifest.Builder)HarvestedLowLatencyHlsManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public HarvestedManifests build() {
            return new HarvestedManifests(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HarvestedManifests> {
        public Builder hlsManifests(Collection<HarvestedHlsManifest> var1);

        public Builder hlsManifests(HarvestedHlsManifest ... var1);

        public Builder hlsManifests(Consumer<HarvestedHlsManifest.Builder> ... var1);

        public Builder dashManifests(Collection<HarvestedDashManifest> var1);

        public Builder dashManifests(HarvestedDashManifest ... var1);

        public Builder dashManifests(Consumer<HarvestedDashManifest.Builder> ... var1);

        public Builder lowLatencyHlsManifests(Collection<HarvestedLowLatencyHlsManifest> var1);

        public Builder lowLatencyHlsManifests(HarvestedLowLatencyHlsManifest ... var1);

        public Builder lowLatencyHlsManifests(Consumer<HarvestedLowLatencyHlsManifest.Builder> ... var1);
    }
}

