/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DashProfile {
    DVB_DASH("DVB_DASH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashProfile> VALUE_MAP;
    private final String value;

    private DashProfile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DashProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DashProfile> knownValues() {
        EnumSet<DashProfile> knownValues = EnumSet.allOf(DashProfile.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DashProfile.class, DashProfile::toString);
    }
}

