/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceTypeNotFound {
    CHANNEL_GROUP("CHANNEL_GROUP"),
    CHANNEL("CHANNEL"),
    ORIGIN_ENDPOINT("ORIGIN_ENDPOINT"),
    HARVEST_JOB("HARVEST_JOB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceTypeNotFound> VALUE_MAP;
    private final String value;

    private ResourceTypeNotFound(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceTypeNotFound fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceTypeNotFound> knownValues() {
        EnumSet<ResourceTypeNotFound> knownValues = EnumSet.allOf(ResourceTypeNotFound.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceTypeNotFound.class, ResourceTypeNotFound::toString);
    }
}

