/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ClusterAlert;
import software.amazon.awssdk.services.medialive.model.ListClusterAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListClusterAlertsResponse;

public class ListClusterAlertsPublisher
implements SdkPublisher<ListClusterAlertsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListClusterAlertsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterAlertsPublisher(MediaLiveAsyncClient client, ListClusterAlertsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterAlertsPublisher(MediaLiveAsyncClient client, ListClusterAlertsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterAlertsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterAlertsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterAlert> alerts() {
        Function<ListClusterAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.alerts() != null) {
                return response.alerts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClusterAlertsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClusterAlertsResponseFetcher
    implements AsyncPageFetcher<ListClusterAlertsResponse> {
        private ListClusterAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterAlertsResponse> nextPage(ListClusterAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterAlertsPublisher.this.client.listClusterAlerts(ListClusterAlertsPublisher.this.firstRequest);
            }
            return ListClusterAlertsPublisher.this.client.listClusterAlerts((ListClusterAlertsRequest)((Object)ListClusterAlertsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

