/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.RouterDestinationSettings;
import software.amazon.awssdk.services.medialive.model.RouterEncryptionType;
import software.amazon.awssdk.services.medialive.model.___listOfRouterDestinationSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterSettings> {
    private static final SdkField<List<RouterDestinationSettings>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(RouterSettings.getter(RouterSettings::destinations)).setter(RouterSettings.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(RouterSettings.getter(RouterSettings::encryptionTypeAsString)).setter(RouterSettings.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(RouterSettings.getter(RouterSettings::secretArn)).setter(RouterSettings.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, ENCRYPTION_TYPE_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RouterDestinationSettings> destinations;
    private final String encryptionType;
    private final String secretArn;

    private RouterSettings(BuilderImpl builder) {
        this.destinations = builder.destinations;
        this.encryptionType = builder.encryptionType;
        this.secretArn = builder.secretArn;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<RouterDestinationSettings> destinations() {
        return this.destinations;
    }

    public final RouterEncryptionType encryptionType() {
        return RouterEncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterSettings)) {
            return false;
        }
        RouterSettings other = (RouterSettings)obj;
        return this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"RouterSettings").add("Destinations", this.hasDestinations() ? this.destinations() : null).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("secretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterSettings, T> g) {
        return obj -> g.apply((RouterSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RouterDestinationSettings> destinations = DefaultSdkAutoConstructList.getInstance();
        private String encryptionType;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterSettings model) {
            this.destinations(model.destinations);
            this.encryptionType(model.encryptionType);
            this.secretArn(model.secretArn);
        }

        public final List<RouterDestinationSettings.Builder> getDestinations() {
            List<RouterDestinationSettings.Builder> result = ___listOfRouterDestinationSettingsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<RouterDestinationSettings.BuilderImpl> destinations) {
            this.destinations = ___listOfRouterDestinationSettingsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<RouterDestinationSettings> destinations) {
            this.destinations = ___listOfRouterDestinationSettingsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(RouterDestinationSettings ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<RouterDestinationSettings.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (RouterDestinationSettings)((RouterDestinationSettings.Builder)RouterDestinationSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(RouterEncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public RouterSettings build() {
            return new RouterSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterSettings> {
        public Builder destinations(Collection<RouterDestinationSettings> var1);

        public Builder destinations(RouterDestinationSettings ... var1);

        public Builder destinations(Consumer<RouterDestinationSettings.Builder> ... var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(RouterEncryptionType var1);

        public Builder secretArn(String var1);
    }
}

