/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ClusterAlert;
import software.amazon.awssdk.services.medialive.model.ListClusterAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListClusterAlertsResponse;

public class ListClusterAlertsIterable
implements SdkIterable<ListClusterAlertsResponse> {
    private final MediaLiveClient client;
    private final ListClusterAlertsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterAlertsIterable(MediaLiveClient client, ListClusterAlertsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClusterAlertsResponseFetcher();
    }

    public Iterator<ListClusterAlertsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterAlert> alerts() {
        Function<ListClusterAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.alerts() != null) {
                return response.alerts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterAlertsResponseFetcher
    implements SyncPageFetcher<ListClusterAlertsResponse> {
        private ListClusterAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterAlertsResponse nextPage(ListClusterAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterAlertsIterable.this.client.listClusterAlerts(ListClusterAlertsIterable.this.firstRequest);
            }
            return ListClusterAlertsIterable.this.client.listClusterAlerts((ListClusterAlertsRequest)((Object)ListClusterAlertsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

