/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputDestinationRequest;
import software.amazon.awssdk.services.medialive.model.InputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.InputSdiSourcesCopier;
import software.amazon.awssdk.services.medialive.model.InputSourceRequest;
import software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.MulticastSettingsUpdateRequest;
import software.amazon.awssdk.services.medialive.model.Smpte2110ReceiverGroupSettings;
import software.amazon.awssdk.services.medialive.model.SpecialRouterSettings;
import software.amazon.awssdk.services.medialive.model.SrtSettingsRequest;
import software.amazon.awssdk.services.medialive.model.___listOfInputDestinationRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputDeviceRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputSourceRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfMediaConnectFlowRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInputRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateInputRequest> {
    private static final SdkField<List<InputDestinationRequest>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(UpdateInputRequest.getter(UpdateInputRequest::destinations)).setter(UpdateInputRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDestinationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputDeviceRequest>> INPUT_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDevices").getter(UpdateInputRequest.getter(UpdateInputRequest::inputDevices)).setter(UpdateInputRequest.setter(Builder::inputDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDeviceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputId").getter(UpdateInputRequest.getter(UpdateInputRequest::inputId)).setter(UpdateInputRequest.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputId").build()}).build();
    private static final SdkField<List<String>> INPUT_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputSecurityGroups").getter(UpdateInputRequest.getter(UpdateInputRequest::inputSecurityGroups)).setter(UpdateInputRequest.setter(Builder::inputSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MediaConnectFlowRequest>> MEDIA_CONNECT_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConnectFlows").getter(UpdateInputRequest.getter(UpdateInputRequest::mediaConnectFlows)).setter(UpdateInputRequest.setter(Builder::mediaConnectFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConnectFlowRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateInputRequest.getter(UpdateInputRequest::name)).setter(UpdateInputRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateInputRequest.getter(UpdateInputRequest::roleArn)).setter(UpdateInputRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<InputSourceRequest>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(UpdateInputRequest.getter(UpdateInputRequest::sources)).setter(UpdateInputRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SrtSettingsRequest> SRT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SrtSettings").getter(UpdateInputRequest.getter(UpdateInputRequest::srtSettings)).setter(UpdateInputRequest.setter(Builder::srtSettings)).constructor(SrtSettingsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtSettings").build()}).build();
    private static final SdkField<MulticastSettingsUpdateRequest> MULTICAST_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MulticastSettings").getter(UpdateInputRequest.getter(UpdateInputRequest::multicastSettings)).setter(UpdateInputRequest.setter(Builder::multicastSettings)).constructor(MulticastSettingsUpdateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastSettings").build()}).build();
    private static final SdkField<Smpte2110ReceiverGroupSettings> SMPTE2110_RECEIVER_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Smpte2110ReceiverGroupSettings").getter(UpdateInputRequest.getter(UpdateInputRequest::smpte2110ReceiverGroupSettings)).setter(UpdateInputRequest.setter(Builder::smpte2110ReceiverGroupSettings)).constructor(Smpte2110ReceiverGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smpte2110ReceiverGroupSettings").build()}).build();
    private static final SdkField<List<String>> SDI_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SdiSources").getter(UpdateInputRequest.getter(UpdateInputRequest::sdiSources)).setter(UpdateInputRequest.setter(Builder::sdiSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdiSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SpecialRouterSettings> SPECIAL_ROUTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpecialRouterSettings").getter(UpdateInputRequest.getter(UpdateInputRequest::specialRouterSettings)).setter(UpdateInputRequest.setter(Builder::specialRouterSettings)).constructor(SpecialRouterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specialRouterSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, INPUT_DEVICES_FIELD, INPUT_ID_FIELD, INPUT_SECURITY_GROUPS_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SOURCES_FIELD, SRT_SETTINGS_FIELD, MULTICAST_SETTINGS_FIELD, SMPTE2110_RECEIVER_GROUP_SETTINGS_FIELD, SDI_SOURCES_FIELD, SPECIAL_ROUTER_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInputRequest.memberNameToFieldInitializer();
    private final List<InputDestinationRequest> destinations;
    private final List<InputDeviceRequest> inputDevices;
    private final String inputId;
    private final List<String> inputSecurityGroups;
    private final List<MediaConnectFlowRequest> mediaConnectFlows;
    private final String name;
    private final String roleArn;
    private final List<InputSourceRequest> sources;
    private final SrtSettingsRequest srtSettings;
    private final MulticastSettingsUpdateRequest multicastSettings;
    private final Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings;
    private final List<String> sdiSources;
    private final SpecialRouterSettings specialRouterSettings;

    private UpdateInputRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.inputDevices = builder.inputDevices;
        this.inputId = builder.inputId;
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.sources = builder.sources;
        this.srtSettings = builder.srtSettings;
        this.multicastSettings = builder.multicastSettings;
        this.smpte2110ReceiverGroupSettings = builder.smpte2110ReceiverGroupSettings;
        this.sdiSources = builder.sdiSources;
        this.specialRouterSettings = builder.specialRouterSettings;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<InputDestinationRequest> destinations() {
        return this.destinations;
    }

    public final boolean hasInputDevices() {
        return this.inputDevices != null && !(this.inputDevices instanceof SdkAutoConstructList);
    }

    public final List<InputDeviceRequest> inputDevices() {
        return this.inputDevices;
    }

    public final String inputId() {
        return this.inputId;
    }

    public final boolean hasInputSecurityGroups() {
        return this.inputSecurityGroups != null && !(this.inputSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> inputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public final boolean hasMediaConnectFlows() {
        return this.mediaConnectFlows != null && !(this.mediaConnectFlows instanceof SdkAutoConstructList);
    }

    public final List<MediaConnectFlowRequest> mediaConnectFlows() {
        return this.mediaConnectFlows;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<InputSourceRequest> sources() {
        return this.sources;
    }

    public final SrtSettingsRequest srtSettings() {
        return this.srtSettings;
    }

    public final MulticastSettingsUpdateRequest multicastSettings() {
        return this.multicastSettings;
    }

    public final Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings() {
        return this.smpte2110ReceiverGroupSettings;
    }

    public final boolean hasSdiSources() {
        return this.sdiSources != null && !(this.sdiSources instanceof SdkAutoConstructList);
    }

    public final List<String> sdiSources() {
        return this.sdiSources;
    }

    public final SpecialRouterSettings specialRouterSettings() {
        return this.specialRouterSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDevices() ? this.inputDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSecurityGroups() ? this.inputSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaConnectFlows() ? this.mediaConnectFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.srtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.smpte2110ReceiverGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSdiSources() ? this.sdiSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.specialRouterSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputRequest)) {
            return false;
        }
        UpdateInputRequest other = (UpdateInputRequest)((Object)obj);
        return this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasInputDevices() == other.hasInputDevices() && Objects.equals(this.inputDevices(), other.inputDevices()) && Objects.equals(this.inputId(), other.inputId()) && this.hasInputSecurityGroups() == other.hasInputSecurityGroups() && Objects.equals(this.inputSecurityGroups(), other.inputSecurityGroups()) && this.hasMediaConnectFlows() == other.hasMediaConnectFlows() && Objects.equals(this.mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.srtSettings(), other.srtSettings()) && Objects.equals(this.multicastSettings(), other.multicastSettings()) && Objects.equals(this.smpte2110ReceiverGroupSettings(), other.smpte2110ReceiverGroupSettings()) && this.hasSdiSources() == other.hasSdiSources() && Objects.equals(this.sdiSources(), other.sdiSources()) && Objects.equals(this.specialRouterSettings(), other.specialRouterSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInputRequest").add("Destinations", this.hasDestinations() ? this.destinations() : null).add("InputDevices", this.hasInputDevices() ? this.inputDevices() : null).add("InputId", (Object)this.inputId()).add("InputSecurityGroups", this.hasInputSecurityGroups() ? this.inputSecurityGroups() : null).add("MediaConnectFlows", this.hasMediaConnectFlows() ? this.mediaConnectFlows() : null).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("Sources", this.hasSources() ? this.sources() : null).add("SrtSettings", (Object)this.srtSettings()).add("MulticastSettings", (Object)this.multicastSettings()).add("Smpte2110ReceiverGroupSettings", (Object)this.smpte2110ReceiverGroupSettings()).add("SdiSources", this.hasSdiSources() ? this.sdiSources() : null).add("SpecialRouterSettings", (Object)this.specialRouterSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "InputDevices": {
                return Optional.ofNullable(clazz.cast(this.inputDevices()));
            }
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "InputSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.inputSecurityGroups()));
            }
            case "MediaConnectFlows": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlows()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "SrtSettings": {
                return Optional.ofNullable(clazz.cast(this.srtSettings()));
            }
            case "MulticastSettings": {
                return Optional.ofNullable(clazz.cast(this.multicastSettings()));
            }
            case "Smpte2110ReceiverGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.smpte2110ReceiverGroupSettings()));
            }
            case "SdiSources": {
                return Optional.ofNullable(clazz.cast(this.sdiSources()));
            }
            case "SpecialRouterSettings": {
                return Optional.ofNullable(clazz.cast(this.specialRouterSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("inputDevices", INPUT_DEVICES_FIELD);
        map.put("inputId", INPUT_ID_FIELD);
        map.put("inputSecurityGroups", INPUT_SECURITY_GROUPS_FIELD);
        map.put("mediaConnectFlows", MEDIA_CONNECT_FLOWS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("srtSettings", SRT_SETTINGS_FIELD);
        map.put("multicastSettings", MULTICAST_SETTINGS_FIELD);
        map.put("smpte2110ReceiverGroupSettings", SMPTE2110_RECEIVER_GROUP_SETTINGS_FIELD);
        map.put("sdiSources", SDI_SOURCES_FIELD);
        map.put("specialRouterSettings", SPECIAL_ROUTER_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputRequest, T> g) {
        return obj -> g.apply((UpdateInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<InputDestinationRequest> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<InputDeviceRequest> inputDevices = DefaultSdkAutoConstructList.getInstance();
        private String inputId;
        private List<String> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<MediaConnectFlowRequest> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String roleArn;
        private List<InputSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();
        private SrtSettingsRequest srtSettings;
        private MulticastSettingsUpdateRequest multicastSettings;
        private Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings;
        private List<String> sdiSources = DefaultSdkAutoConstructList.getInstance();
        private SpecialRouterSettings specialRouterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputRequest model) {
            super(model);
            this.destinations(model.destinations);
            this.inputDevices(model.inputDevices);
            this.inputId(model.inputId);
            this.inputSecurityGroups(model.inputSecurityGroups);
            this.mediaConnectFlows(model.mediaConnectFlows);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.sources(model.sources);
            this.srtSettings(model.srtSettings);
            this.multicastSettings(model.multicastSettings);
            this.smpte2110ReceiverGroupSettings(model.smpte2110ReceiverGroupSettings);
            this.sdiSources(model.sdiSources);
            this.specialRouterSettings(model.specialRouterSettings);
        }

        public final List<InputDestinationRequest.Builder> getDestinations() {
            List<InputDestinationRequest.Builder> result = ___listOfInputDestinationRequestCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<InputDestinationRequest.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<InputDestinationRequest> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestinationRequest ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestinationRequest.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestinationRequest)((InputDestinationRequest.Builder)InputDestinationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InputDeviceRequest.Builder> getInputDevices() {
            List<InputDeviceRequest.Builder> result = ___listOfInputDeviceRequestCopier.copyToBuilder(this.inputDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDevices(Collection<InputDeviceRequest.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copyFromBuilder(inputDevices);
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceRequest> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceRequest ... inputDevices) {
            this.inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceRequest.Builder> ... inputDevices) {
            this.inputDevices(Stream.of(inputDevices).map(c -> (InputDeviceRequest)((InputDeviceRequest.Builder)InputDeviceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInputId() {
            return this.inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final Collection<String> getInputSecurityGroups() {
            if (this.inputSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputSecurityGroups;
        }

        public final void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
        }

        @Override
        public final Builder inputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(String ... inputSecurityGroups) {
            this.inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final List<MediaConnectFlowRequest.Builder> getMediaConnectFlows() {
            List<MediaConnectFlowRequest.Builder> result = ___listOfMediaConnectFlowRequestCopier.copyToBuilder(this.mediaConnectFlows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlowRequest.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copyFromBuilder(mediaConnectFlows);
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlowRequest ... mediaConnectFlows) {
            this.mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder> ... mediaConnectFlows) {
            this.mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> (MediaConnectFlowRequest)((MediaConnectFlowRequest.Builder)MediaConnectFlowRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<InputSourceRequest.Builder> getSources() {
            List<InputSourceRequest.Builder> result = ___listOfInputSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<InputSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<InputSourceRequest> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSourceRequest ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSourceRequest.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSourceRequest)((InputSourceRequest.Builder)InputSourceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SrtSettingsRequest.Builder getSrtSettings() {
            return this.srtSettings != null ? this.srtSettings.toBuilder() : null;
        }

        public final void setSrtSettings(SrtSettingsRequest.BuilderImpl srtSettings) {
            this.srtSettings = srtSettings != null ? srtSettings.build() : null;
        }

        @Override
        public final Builder srtSettings(SrtSettingsRequest srtSettings) {
            this.srtSettings = srtSettings;
            return this;
        }

        public final MulticastSettingsUpdateRequest.Builder getMulticastSettings() {
            return this.multicastSettings != null ? this.multicastSettings.toBuilder() : null;
        }

        public final void setMulticastSettings(MulticastSettingsUpdateRequest.BuilderImpl multicastSettings) {
            this.multicastSettings = multicastSettings != null ? multicastSettings.build() : null;
        }

        @Override
        public final Builder multicastSettings(MulticastSettingsUpdateRequest multicastSettings) {
            this.multicastSettings = multicastSettings;
            return this;
        }

        public final Smpte2110ReceiverGroupSettings.Builder getSmpte2110ReceiverGroupSettings() {
            return this.smpte2110ReceiverGroupSettings != null ? this.smpte2110ReceiverGroupSettings.toBuilder() : null;
        }

        public final void setSmpte2110ReceiverGroupSettings(Smpte2110ReceiverGroupSettings.BuilderImpl smpte2110ReceiverGroupSettings) {
            this.smpte2110ReceiverGroupSettings = smpte2110ReceiverGroupSettings != null ? smpte2110ReceiverGroupSettings.build() : null;
        }

        @Override
        public final Builder smpte2110ReceiverGroupSettings(Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings) {
            this.smpte2110ReceiverGroupSettings = smpte2110ReceiverGroupSettings;
            return this;
        }

        public final Collection<String> getSdiSources() {
            if (this.sdiSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sdiSources;
        }

        public final void setSdiSources(Collection<String> sdiSources) {
            this.sdiSources = InputSdiSourcesCopier.copy(sdiSources);
        }

        @Override
        public final Builder sdiSources(Collection<String> sdiSources) {
            this.sdiSources = InputSdiSourcesCopier.copy(sdiSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sdiSources(String ... sdiSources) {
            this.sdiSources(Arrays.asList(sdiSources));
            return this;
        }

        public final SpecialRouterSettings.Builder getSpecialRouterSettings() {
            return this.specialRouterSettings != null ? this.specialRouterSettings.toBuilder() : null;
        }

        public final void setSpecialRouterSettings(SpecialRouterSettings.BuilderImpl specialRouterSettings) {
            this.specialRouterSettings = specialRouterSettings != null ? specialRouterSettings.build() : null;
        }

        @Override
        public final Builder specialRouterSettings(SpecialRouterSettings specialRouterSettings) {
            this.specialRouterSettings = specialRouterSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputRequest build() {
            return new UpdateInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInputRequest> {
        public Builder destinations(Collection<InputDestinationRequest> var1);

        public Builder destinations(InputDestinationRequest ... var1);

        public Builder destinations(Consumer<InputDestinationRequest.Builder> ... var1);

        public Builder inputDevices(Collection<InputDeviceRequest> var1);

        public Builder inputDevices(InputDeviceRequest ... var1);

        public Builder inputDevices(Consumer<InputDeviceRequest.Builder> ... var1);

        public Builder inputId(String var1);

        public Builder inputSecurityGroups(Collection<String> var1);

        public Builder inputSecurityGroups(String ... var1);

        public Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> var1);

        public Builder mediaConnectFlows(MediaConnectFlowRequest ... var1);

        public Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder> ... var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder sources(Collection<InputSourceRequest> var1);

        public Builder sources(InputSourceRequest ... var1);

        public Builder sources(Consumer<InputSourceRequest.Builder> ... var1);

        public Builder srtSettings(SrtSettingsRequest var1);

        default public Builder srtSettings(Consumer<SrtSettingsRequest.Builder> srtSettings) {
            return this.srtSettings((SrtSettingsRequest)((SrtSettingsRequest.Builder)SrtSettingsRequest.builder().applyMutation(srtSettings)).build());
        }

        public Builder multicastSettings(MulticastSettingsUpdateRequest var1);

        default public Builder multicastSettings(Consumer<MulticastSettingsUpdateRequest.Builder> multicastSettings) {
            return this.multicastSettings((MulticastSettingsUpdateRequest)((MulticastSettingsUpdateRequest.Builder)MulticastSettingsUpdateRequest.builder().applyMutation(multicastSettings)).build());
        }

        public Builder smpte2110ReceiverGroupSettings(Smpte2110ReceiverGroupSettings var1);

        default public Builder smpte2110ReceiverGroupSettings(Consumer<Smpte2110ReceiverGroupSettings.Builder> smpte2110ReceiverGroupSettings) {
            return this.smpte2110ReceiverGroupSettings((Smpte2110ReceiverGroupSettings)((Smpte2110ReceiverGroupSettings.Builder)Smpte2110ReceiverGroupSettings.builder().applyMutation(smpte2110ReceiverGroupSettings)).build());
        }

        public Builder sdiSources(Collection<String> var1);

        public Builder sdiSources(String ... var1);

        public Builder specialRouterSettings(SpecialRouterSettings var1);

        default public Builder specialRouterSettings(Consumer<SpecialRouterSettings.Builder> specialRouterSettings) {
            return this.specialRouterSettings((SpecialRouterSettings)((SpecialRouterSettings.Builder)SpecialRouterSettings.builder().applyMutation(specialRouterSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

