/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlertsRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, ListAlertsRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(ListAlertsRequest.getter(ListAlertsRequest::channelId)).setter(ListAlertsRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAlertsRequest.getter(ListAlertsRequest::maxResults)).setter(ListAlertsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAlertsRequest.getter(ListAlertsRequest::nextToken)).setter(ListAlertsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> STATE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateFilter").getter(ListAlertsRequest.getter(ListAlertsRequest::stateFilter)).setter(ListAlertsRequest.setter(Builder::stateFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("stateFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAlertsRequest.memberNameToFieldInitializer();
    private final String channelId;
    private final Integer maxResults;
    private final String nextToken;
    private final String stateFilter;

    private ListAlertsRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.stateFilter = builder.stateFilter;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String stateFilter() {
        return this.stateFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlertsRequest)) {
            return false;
        }
        ListAlertsRequest other = (ListAlertsRequest)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.stateFilter(), other.stateFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListAlertsRequest").add("ChannelId", (Object)this.channelId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("StateFilter", (Object)this.stateFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StateFilter": {
                return Optional.ofNullable(clazz.cast(this.stateFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("stateFilter", STATE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAlertsRequest, T> g) {
        return obj -> g.apply((ListAlertsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelId;
        private Integer maxResults;
        private String nextToken;
        private String stateFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlertsRequest model) {
            super(model);
            this.channelId(model.channelId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.stateFilter(model.stateFilter);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStateFilter() {
            return this.stateFilter;
        }

        public final void setStateFilter(String stateFilter) {
            this.stateFilter = stateFilter;
        }

        @Override
        public final Builder stateFilter(String stateFilter) {
            this.stateFilter = stateFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAlertsRequest build() {
            return new ListAlertsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlertsRequest> {
        public Builder channelId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder stateFilter(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

