/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.LinkedChannelType;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePrimaryChannelSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribePrimaryChannelSettings> {
    private static final SdkField<List<String>> FOLLOWING_CHANNEL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FollowingChannelArns").getter(DescribePrimaryChannelSettings.getter(DescribePrimaryChannelSettings::followingChannelArns)).setter(DescribePrimaryChannelSettings.setter(Builder::followingChannelArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followingChannelArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LINKED_CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkedChannelType").getter(DescribePrimaryChannelSettings.getter(DescribePrimaryChannelSettings::linkedChannelTypeAsString)).setter(DescribePrimaryChannelSettings.setter(Builder::linkedChannelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedChannelType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLLOWING_CHANNEL_ARNS_FIELD, LINKED_CHANNEL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePrimaryChannelSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> followingChannelArns;
    private final String linkedChannelType;

    private DescribePrimaryChannelSettings(BuilderImpl builder) {
        this.followingChannelArns = builder.followingChannelArns;
        this.linkedChannelType = builder.linkedChannelType;
    }

    public final boolean hasFollowingChannelArns() {
        return this.followingChannelArns != null && !(this.followingChannelArns instanceof SdkAutoConstructList);
    }

    public final List<String> followingChannelArns() {
        return this.followingChannelArns;
    }

    public final LinkedChannelType linkedChannelType() {
        return LinkedChannelType.fromValue(this.linkedChannelType);
    }

    public final String linkedChannelTypeAsString() {
        return this.linkedChannelType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFollowingChannelArns() ? this.followingChannelArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedChannelTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrimaryChannelSettings)) {
            return false;
        }
        DescribePrimaryChannelSettings other = (DescribePrimaryChannelSettings)obj;
        return this.hasFollowingChannelArns() == other.hasFollowingChannelArns() && Objects.equals(this.followingChannelArns(), other.followingChannelArns()) && Objects.equals(this.linkedChannelTypeAsString(), other.linkedChannelTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePrimaryChannelSettings").add("FollowingChannelArns", this.hasFollowingChannelArns() ? this.followingChannelArns() : null).add("LinkedChannelType", (Object)this.linkedChannelTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FollowingChannelArns": {
                return Optional.ofNullable(clazz.cast(this.followingChannelArns()));
            }
            case "LinkedChannelType": {
                return Optional.ofNullable(clazz.cast(this.linkedChannelTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("followingChannelArns", FOLLOWING_CHANNEL_ARNS_FIELD);
        map.put("linkedChannelType", LINKED_CHANNEL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePrimaryChannelSettings, T> g) {
        return obj -> g.apply((DescribePrimaryChannelSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> followingChannelArns = DefaultSdkAutoConstructList.getInstance();
        private String linkedChannelType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrimaryChannelSettings model) {
            this.followingChannelArns(model.followingChannelArns);
            this.linkedChannelType(model.linkedChannelType);
        }

        public final Collection<String> getFollowingChannelArns() {
            if (this.followingChannelArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.followingChannelArns;
        }

        public final void setFollowingChannelArns(Collection<String> followingChannelArns) {
            this.followingChannelArns = ___listOf__stringCopier.copy(followingChannelArns);
        }

        @Override
        public final Builder followingChannelArns(Collection<String> followingChannelArns) {
            this.followingChannelArns = ___listOf__stringCopier.copy(followingChannelArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder followingChannelArns(String ... followingChannelArns) {
            this.followingChannelArns(Arrays.asList(followingChannelArns));
            return this;
        }

        public final String getLinkedChannelType() {
            return this.linkedChannelType;
        }

        public final void setLinkedChannelType(String linkedChannelType) {
            this.linkedChannelType = linkedChannelType;
        }

        @Override
        public final Builder linkedChannelType(String linkedChannelType) {
            this.linkedChannelType = linkedChannelType;
            return this;
        }

        @Override
        public final Builder linkedChannelType(LinkedChannelType linkedChannelType) {
            this.linkedChannelType(linkedChannelType == null ? null : linkedChannelType.toString());
            return this;
        }

        public DescribePrimaryChannelSettings build() {
            return new DescribePrimaryChannelSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribePrimaryChannelSettings> {
        public Builder followingChannelArns(Collection<String> var1);

        public Builder followingChannelArns(String ... var1);

        public Builder linkedChannelType(String var1);

        public Builder linkedChannelType(LinkedChannelType var1);
    }
}

