/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse;
import software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary;

public class ListInputDeviceTransfersPublisher
implements SdkPublisher<ListInputDeviceTransfersResponse> {
    private final MediaLiveAsyncClient client;
    private final ListInputDeviceTransfersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInputDeviceTransfersPublisher(MediaLiveAsyncClient client, ListInputDeviceTransfersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInputDeviceTransfersPublisher(MediaLiveAsyncClient client, ListInputDeviceTransfersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInputDeviceTransfersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInputDeviceTransfersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransferringInputDeviceSummary> inputDeviceTransfers() {
        Function<ListInputDeviceTransfersResponse, Iterator> getIterator = response -> {
            if (response != null && response.inputDeviceTransfers() != null) {
                return response.inputDeviceTransfers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInputDeviceTransfersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInputDeviceTransfersResponseFetcher
    implements AsyncPageFetcher<ListInputDeviceTransfersResponse> {
        private ListInputDeviceTransfersResponseFetcher() {
        }

        public boolean hasNextPage(ListInputDeviceTransfersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInputDeviceTransfersResponse> nextPage(ListInputDeviceTransfersResponse previousPage) {
            if (previousPage == null) {
                return ListInputDeviceTransfersPublisher.this.client.listInputDeviceTransfers(ListInputDeviceTransfersPublisher.this.firstRequest);
            }
            return ListInputDeviceTransfersPublisher.this.client.listInputDeviceTransfers((ListInputDeviceTransfersRequest)((Object)ListInputDeviceTransfersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

