/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeRole {
    BACKUP("BACKUP"),
    ACTIVE("ACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeRole> VALUE_MAP;
    private final String value;

    private NodeRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeRole> knownValues() {
        EnumSet<NodeRole> knownValues = EnumSet.allOf(NodeRole.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeRole.class, NodeRole::toString);
    }
}

