/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MaintenanceDay;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceStatus> {
    private static final SdkField<String> MAINTENANCE_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceDay").getter(MaintenanceStatus.getter(MaintenanceStatus::maintenanceDayAsString)).setter(MaintenanceStatus.setter(Builder::maintenanceDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDay").build()}).build();
    private static final SdkField<String> MAINTENANCE_DEADLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceDeadline").getter(MaintenanceStatus.getter(MaintenanceStatus::maintenanceDeadline)).setter(MaintenanceStatus.setter(Builder::maintenanceDeadline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDeadline").build()}).build();
    private static final SdkField<String> MAINTENANCE_SCHEDULED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceScheduledDate").getter(MaintenanceStatus.getter(MaintenanceStatus::maintenanceScheduledDate)).setter(MaintenanceStatus.setter(Builder::maintenanceScheduledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduledDate").build()}).build();
    private static final SdkField<String> MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceStartTime").getter(MaintenanceStatus.getter(MaintenanceStatus::maintenanceStartTime)).setter(MaintenanceStatus.setter(Builder::maintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_DAY_FIELD, MAINTENANCE_DEADLINE_FIELD, MAINTENANCE_SCHEDULED_DATE_FIELD, MAINTENANCE_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MaintenanceStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String maintenanceDay;
    private final String maintenanceDeadline;
    private final String maintenanceScheduledDate;
    private final String maintenanceStartTime;

    private MaintenanceStatus(BuilderImpl builder) {
        this.maintenanceDay = builder.maintenanceDay;
        this.maintenanceDeadline = builder.maintenanceDeadline;
        this.maintenanceScheduledDate = builder.maintenanceScheduledDate;
        this.maintenanceStartTime = builder.maintenanceStartTime;
    }

    public final MaintenanceDay maintenanceDay() {
        return MaintenanceDay.fromValue(this.maintenanceDay);
    }

    public final String maintenanceDayAsString() {
        return this.maintenanceDay;
    }

    public final String maintenanceDeadline() {
        return this.maintenanceDeadline;
    }

    public final String maintenanceScheduledDate() {
        return this.maintenanceScheduledDate;
    }

    public final String maintenanceStartTime() {
        return this.maintenanceStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceDeadline());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceScheduledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceStatus)) {
            return false;
        }
        MaintenanceStatus other = (MaintenanceStatus)obj;
        return Objects.equals(this.maintenanceDayAsString(), other.maintenanceDayAsString()) && Objects.equals(this.maintenanceDeadline(), other.maintenanceDeadline()) && Objects.equals(this.maintenanceScheduledDate(), other.maintenanceScheduledDate()) && Objects.equals(this.maintenanceStartTime(), other.maintenanceStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceStatus").add("MaintenanceDay", (Object)this.maintenanceDayAsString()).add("MaintenanceDeadline", (Object)this.maintenanceDeadline()).add("MaintenanceScheduledDate", (Object)this.maintenanceScheduledDate()).add("MaintenanceStartTime", (Object)this.maintenanceStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceDay": {
                return Optional.ofNullable(clazz.cast(this.maintenanceDayAsString()));
            }
            case "MaintenanceDeadline": {
                return Optional.ofNullable(clazz.cast(this.maintenanceDeadline()));
            }
            case "MaintenanceScheduledDate": {
                return Optional.ofNullable(clazz.cast(this.maintenanceScheduledDate()));
            }
            case "MaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.maintenanceStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("maintenanceDay", MAINTENANCE_DAY_FIELD);
        map.put("maintenanceDeadline", MAINTENANCE_DEADLINE_FIELD);
        map.put("maintenanceScheduledDate", MAINTENANCE_SCHEDULED_DATE_FIELD);
        map.put("maintenanceStartTime", MAINTENANCE_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceStatus, T> g) {
        return obj -> g.apply((MaintenanceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String maintenanceDay;
        private String maintenanceDeadline;
        private String maintenanceScheduledDate;
        private String maintenanceStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceStatus model) {
            this.maintenanceDay(model.maintenanceDay);
            this.maintenanceDeadline(model.maintenanceDeadline);
            this.maintenanceScheduledDate(model.maintenanceScheduledDate);
            this.maintenanceStartTime(model.maintenanceStartTime);
        }

        public final String getMaintenanceDay() {
            return this.maintenanceDay;
        }

        public final void setMaintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
        }

        @Override
        public final Builder maintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
            return this;
        }

        @Override
        public final Builder maintenanceDay(MaintenanceDay maintenanceDay) {
            this.maintenanceDay(maintenanceDay == null ? null : maintenanceDay.toString());
            return this;
        }

        public final String getMaintenanceDeadline() {
            return this.maintenanceDeadline;
        }

        public final void setMaintenanceDeadline(String maintenanceDeadline) {
            this.maintenanceDeadline = maintenanceDeadline;
        }

        @Override
        public final Builder maintenanceDeadline(String maintenanceDeadline) {
            this.maintenanceDeadline = maintenanceDeadline;
            return this;
        }

        public final String getMaintenanceScheduledDate() {
            return this.maintenanceScheduledDate;
        }

        public final void setMaintenanceScheduledDate(String maintenanceScheduledDate) {
            this.maintenanceScheduledDate = maintenanceScheduledDate;
        }

        @Override
        public final Builder maintenanceScheduledDate(String maintenanceScheduledDate) {
            this.maintenanceScheduledDate = maintenanceScheduledDate;
            return this;
        }

        public final String getMaintenanceStartTime() {
            return this.maintenanceStartTime;
        }

        public final void setMaintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
        }

        @Override
        public final Builder maintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
            return this;
        }

        public MaintenanceStatus build() {
            return new MaintenanceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceStatus> {
        public Builder maintenanceDay(String var1);

        public Builder maintenanceDay(MaintenanceDay var1);

        public Builder maintenanceDeadline(String var1);

        public Builder maintenanceScheduledDate(String var1);

        public Builder maintenanceStartTime(String var1);
    }
}

