/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputCodec {
    MPEG2("MPEG2"),
    AVC("AVC"),
    HEVC("HEVC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputCodec> VALUE_MAP;
    private final String value;

    private InputCodec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputCodec> knownValues() {
        EnumSet<InputCodec> knownValues = EnumSet.allOf(InputCodec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputCodec.class, InputCodec::toString);
    }
}

