/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputClass {
    STANDARD("STANDARD"),
    SINGLE_PIPELINE("SINGLE_PIPELINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputClass> VALUE_MAP;
    private final String value;

    private InputClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputClass> knownValues() {
        EnumSet<InputClass> knownValues = EnumSet.allOf(InputClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputClass.class, InputClass::toString);
    }
}

