/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265RateControlMode {
    CBR("CBR"),
    MULTIPLEX("MULTIPLEX"),
    QVBR("QVBR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265RateControlMode> VALUE_MAP;
    private final String value;

    private H265RateControlMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265RateControlMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265RateControlMode> knownValues() {
        EnumSet<H265RateControlMode> knownValues = EnumSet.allOf(H265RateControlMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265RateControlMode.class, H265RateControlMode::toString);
    }
}

