/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265Profile {
    MAIN("MAIN"),
    MAIN_10_BIT("MAIN_10BIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265Profile> VALUE_MAP;
    private final String value;

    private H265Profile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265Profile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265Profile> knownValues() {
        EnumSet<H265Profile> knownValues = EnumSet.allOf(H265Profile.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265Profile.class, H265Profile::toString);
    }
}

