/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DvbDashAccessibility {
    DVBDASH_1_VISUALLY_IMPAIRED("DVBDASH_1_VISUALLY_IMPAIRED"),
    DVBDASH_2_HARD_OF_HEARING("DVBDASH_2_HARD_OF_HEARING"),
    DVBDASH_3_SUPPLEMENTAL_COMMENTARY("DVBDASH_3_SUPPLEMENTAL_COMMENTARY"),
    DVBDASH_4_DIRECTORS_COMMENTARY("DVBDASH_4_DIRECTORS_COMMENTARY"),
    DVBDASH_5_EDUCATIONAL_NOTES("DVBDASH_5_EDUCATIONAL_NOTES"),
    DVBDASH_6_MAIN_PROGRAM("DVBDASH_6_MAIN_PROGRAM"),
    DVBDASH_7_CLEAN_FEED("DVBDASH_7_CLEAN_FEED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DvbDashAccessibility> VALUE_MAP;
    private final String value;

    private DvbDashAccessibility(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DvbDashAccessibility fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DvbDashAccessibility> knownValues() {
        EnumSet<DvbDashAccessibility> knownValues = EnumSet.allOf(DvbDashAccessibility.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DvbDashAccessibility.class, DvbDashAccessibility::toString);
    }
}

